<?php

use Inside\Host\Bridge\BridgeContentType;

return [
    'options' => [
        'name'  => 'header_file',
        'title' => [
            'fr' => 'Fichier',
        ],
    ],
    'fields'  => [
        // Titre
        [
            'name'        => 'title',
            'default'     => '',
            'required'    => true,
            'weight'      => 1,
            'title'       => [
                'fr' => 'Titre',
                'en' => 'Title',
            ],
            'description' => [
                'fr' => '',
                'en' => '',
            ],
            'widget'      => [
                'type'     => BridgeContentType::TEXT_WIDGET,
                'settings' => [],
            ],
            'type'        => BridgeContentType::TEXT_FIELD,
            'settings'    => [
                'max_length'     => 255,
                'is_ascii'       => false,
                'case_sensitive' => false,
                'cardinality'    => 1,
            ],
        ],
        // Fichier
        [
            'name'                => 'file',
            'searchable'          => true,
            'translatable'        => false,
            'default'             => false,
            'search_result_field' => true,
            'required'            => true,
            'weight'              => 2,
            'title'               => [
                'fr' => 'Fichier',
            ],
            'description'         => [
                'fr' => '',
            ],
            'widget'              => [
                'type'     => BridgeContentType::FILE_WIDGET,
                'settings' => [
                    'progress_indicator' => 'throbber',
                ],
                'weight'   => 1,
            ],
            'type'                => BridgeContentType::FILE_FIELD,
            'settings'            => [
                'display_field'   => false,
                'display_default' => false,
                'uri_scheme'      => 'public',
                'mimetypes'       => 'application/pdf,application/doc,application/docx,application/odt',
                'file_extensions' => 'pdf doc docx odt',
                'target_type'     => 'file',
                'cardinality'     => 1,
            ],
        ],
    ],
];
