<?php

declare(strict_types=1);

use Illuminate\Database\Migrations\Migration;
use Inside\Content\Facades\Schema;
use Inside\Host\Bridge\BridgeContentType;

final class AddDarkModeFieldToEcoDashboardsType extends Migration
{
    public function up(): void
    {
        if (! Schema::hasModel('eco_dashboards')) {
            return;
        }

        $bridge = new BridgeContentType();

        $bridge->contentTypeCreateOrUpdateField(
            type: 'eco_dashboards',
            fieldName: 'dark_mode',
            options: [
                'name' => 'dark_mode',
                'searchable' => false,
                'translatable' => false,
                'search_result_field' => false,
                'search_filter' => false,
                'required' => false,
                'title' => [
                    'fr' => "Passer le texte en blanc",
                    'en' => 'Set the text to white',
                    'es' => 'Pasar el texto a blanco',
                    'de' => 'Den Text auf Weiß setzen',
                    'pt' => 'Definir o texto como branco',
                    'nl' => 'Zet de tekst op wit',
                ],
                'widget' => [
                    'type' => BridgeContentType::BOOLEAN_CHECKBOX_WIDGET,
                    'settings' => [
                        'display_label' => true,
                    ],
                ],
                'type' => BridgeContentType::BOOLEAN_FIELD,
                'settings' => [
                    'cardinality' => 1,
                ],
                'default' => true,
            ],
            weight: 2
        );
    }
}
