<?php

use Illuminate\Support\Facades\Artisan;
use Illuminate\Database\Migrations\Migration;
use Inside\Host\Bridge\BridgeContentType;

final class AddBackgroundColorToCompanyStatistics extends Migration
{
    public function up(): void
    {
        $bridgeContentType = new BridgeContentType();

        $bridgeContentType->contentTypeCreateOrUpdateField(
            type: 'company_statistics',
            fieldName: 'color',
            options: [
                'name' => 'color',
                'searchable' => false,
                'translatable' => true,
                'search_result_field' => false,
                'searchable_filter' => false,
                'required' => false,
                'weight' => 4,
                'title' => [
                    'fr' => 'Couleur du texte',
                    'en' => 'Text color',
                    'es' => 'Color del texto',
                    'de' => 'Textfarbe',
                    'pt' => 'Cor do texto',
                    'nl' => 'Tekstkleur',
                ],
                'description' => [
                    'en' => 'Select your text color',
                    'fr' => 'Sélectionnez la couleur de votre texte',
                    'es' => 'Seleccione el color de su texto',
                    'pt' => 'Selecione a cor do seu texto',
                    'de' => 'Wählen Sie die Farbe Ihres Textes',
                    'nl' => 'Selecteer de kleur van uw tekst',
                ],
                'widget' => [
                    'type' => BridgeContentType::INSIDE_COLOR_PICKER_WIDGET,
                    'settings' => [],
                    'weight' => 4,
                ],
                'type' => BridgeContentType::TEXT_FIELD,
                'settings' => [
                    'max_length' => 255,
                    'is_ascii' => false,
                    'case_sensitive' => false,
                    'cardinality' => 1,
                ],
            ],
            weight: -4
        );

        $bridgeContentType->contentTypeCreateOrUpdateField(
            type: 'company_statistics',
            fieldName: 'background_color',
            options: [
                'name' => 'background_color',
                'searchable' => false,
                'translatable' => false,
                'search_result_field' => false,
                'searchable_filter' => false,
                'required' => false,
                'title' => [
                    'fr' => 'Couleur du fond',
                    'en' => 'Background color',
                    'es' => 'Color de fondo',
                    'de' => 'Hintergrundfarbe',
                    'pt' => 'Cor de fundo',
                    'nl' => 'Achtergrondkleur',
                ],
                'description' => [
                    'fr' => "Si aucune couleur n'est sélectionnée, la couleur secondaire du site sera utilisée.",
                    'en' => 'If no color is selected, the secondary color of the website will be used.',
                    'es' => 'Si no se selecciona ningún color, se utilizará el color secundario del sitio web.',
                    'de' => 'Wenn keine Farbe ausgewählt ist, wird die sekundäre Farbe der Website verwendet.',
                    'pt' => 'Se nenhuma cor for selecionada, será utilizada a cor secundária do site.',
                    'nl' => 'Als er geen kleur is geselecteerd, wordt de secundaire kleur van de website gebruikt.',
                ],
                'widget' => [
                    'type' => BridgeContentType::INSIDE_COLOR_PICKER_WIDGET,
                    'settings' => [],
                ],
                'type' => BridgeContentType::TEXT_FIELD,
                'settings' => [
                    'max_length' => 255,
                    'is_ascii' => false,
                    'case_sensitive' => false,
                    'cardinality' => 1,
                ],
            ],
            weight: -4
        );

        Artisan::call("models:rebuild");
    }
}
