<?php

use Illuminate\Support\Facades\Artisan;
use Illuminate\Database\Migrations\Migration;
use Inside\Host\Bridge\BridgeContentType;
use Inside\Host\Migrations\CreateContentTypes;

final class AddImageBlockContentType extends Migration
{
    use CreateContentTypes;

    public function up(): void
    {
        $bridgeContentType = new BridgeContentType();

        $bridgeContentType->contentTypeUpdateOrCreate(
            type: 'image_block',
            options: [
                'name' => 'image_block',
                'searchable' => true,
                'global_searchable' => false,
                'aliasable' => false,
                'permissible' => false,
                'categorizable' => false,
                'listing_type' => 'content',
                'title' => [
                    'fr' => 'Bloc image ouvrable'
                ],
            ],
            fields: [
                [
                    'name' => 'link',
                    'searchable' => false,
                    'search_result_field' => false,
                    'searchable_filter' => false,
                    'required' => true,
                    'weight' => 0,
                    'title' => [
                        'fr' => 'Lien',
                    ],
                    'widget' => [
                        'type' => BridgeContentType::INSIDE_LINK_WIDGET,
                        'settings' => [],
                        'weight' => 0,
                    ],
                    'type' => BridgeContentType::TEXT_FIELD,
                    'settings' => [
                        'max_length' => 255,
                        'is_ascii' => false,
                        'case_sensitive' => false,
                        'cardinality' => 1,
                    ],
                ],
                [
                    'name' => 'image',
                    'searchable' => false,
                    'search_result_field' => false,
                    'searchable_filter' => false,
                    'required' => true,
                    'weight' => 1,
                    'title' => [
                        'fr' => 'Image',
                    ],
                    'widget' => [
                        'type' => BridgeContentType::IMAGE_WIDGET,
                        'settings' => [
                            'progress_indicator' => 'throbber',
                            'preview_image_style' => 'thumbnail',
                        ],
                        'weight' => 1,
                    ],
                    'type' => BridgeContentType::IMAGE_FIELD,
                    'settings' => [
                        'uri_scheme' => 'public',
                        'default_image' => [
                            'uuid' => '',
                            'alt' => '',
                            'title' => '',
                            'width' => null,
                            'height' => null,
                        ],
                        'target_type' => 'file',
                        'display_field' => false,
                        'display_default' => false,
                        'cardinality' => 1,
                    ],
                ],
                [
                    'name' => 'weight',
                    'searchable' => false,
                    'search_result_field' => false,
                    'searchable_filter' => false,
                    'required' => false,
                    'weight' => 2,
                    'title' => [
                        'fr' => 'Ordre d\'affichage',
                    ],
                    'widget' => [
                        'type' => BridgeContentType::NUMBER_WIDGET,
                        'settings' => [],
                        'weight' => 2,
                    ],
                    'type' => BridgeContentType::INTEGER_FIELD,
                    'settings' => [
                        'cardinality' => 1,
                    ],
                ],
                [
                    'name' => 'open_in_new_tab',
                    'searchable' => false,
                    'search_result_field' => false,
                    'searchable_filter' => false,
                    'required' => false,
                    'weight' => 2,
                    'title' => [
                        'fr' => 'Ouvrir dans un nouvel onglet',
                    ],
                    'widget' => [
                        'type' => BridgeContentType::BOOLEAN_CHECKBOX_WIDGET,
                        'settings' => [
                            'display_label' => true,
                        ],
                        'weight' => 2,
                    ],
                    'type' => BridgeContentType::BOOLEAN_FIELD,
                    'settings' => [
                        'cardinality' => 1,
                    ],
                    'default' => false,
                ]
            ]
        );

        Artisan::call("models:rebuild");
    }
}
