<?php

declare(strict_types=1);

use Illuminate\Database\Migrations\Migration;
use Inside\Content\Models\Contents\Custom;
use Inside\Host\Bridge\BridgeContent;
use Inside\Layout\Models\Layout;

final class AddCustomContentsAndDeleteLayouts extends Migration
{
    public function up(): void
    {
        $customs = [
            [
                'custom_slug' => 'news',
                'redirection_page' => 'NewsListingPage',
                'title' => 'Actualités',
            ],
            [
                'custom_slug' => 'my-ideas',
                'redirection_page' => 'MyIdeasPage',
                'title' => 'Mes idées',
            ],
            [
                'custom_slug' => 'ideas',
                'redirection_page' => 'IdeasPage',
                'title' => 'Les idées',
            ],
            [
                'custom_slug' => 'tools-listing',
                'redirection_page' => 'ToolsPage',
                'title' => 'Outils',
            ],
            [
                'custom_slug' => 'calendar',
                'redirection_page' => 'EventsCalendarPage',
                'title' => 'Événements',
            ],
            [
                'custom_slug' => 'contracts',
                'redirection_page' => 'ContractsListingPage',
                'title' => 'Contrats',
            ],
            [
                'custom_slug' => 'launches',
                'redirection_page' => 'LaunchesListingPage',
                'title' => 'Lancements et livraisons',
            ],
            [
                'custom_slug' => 'ged',
                'redirection_page' => 'GedPage',
                'title' => 'Médiathèque',
            ],
            [
                'custom_slug' => 'directory',
                'redirection_page' => 'DirectoryPage',
                'title' => 'Annuaire',
            ],
            [
                'custom_slug' => 'spaces-listing',
                'redirection_page' => 'SpacesListingPage',
                'title' => 'Espaces thématiques',
            ],
            [
                'custom_slug' => 'jobs-listing',
                'redirection_page' => 'JobsListingPage',
                'title' => 'Offres d’emploi',
            ],
        ];

        $bridge = new BridgeContent();

        foreach ($customs as $custom) {
            $existing = Custom::where('redirection_page', $custom['redirection_page'])->first();

            if ($existing instanceof Custom) {
                $custom['uuid'] = $existing->uuid;
            }

            $bridge->contentInsert('custom', $custom, ! isset($custom['uuid']));
        }

        // Delete all layouts
        Layout::query()->delete();
    }
}
