<?php

use Illuminate\Database\Migrations\Migration;
use Inside\Database\Migrations\HasConsole;
use Inside\Host\Bridge\BridgeContent;
use Inside\Host\Bridge\BridgeContentType;
use Illuminate\Support\Facades\Artisan;

class ChangeNumbersToFloatOnStatistics extends Migration
{
    use HasConsole;

    /** @var array */
    protected $fields = [
        // Actual value
        'current_value' => [
            'name' => 'current_value',
            'searchable' => false,
            'translatable' => false,
            'default' => 0,
            'search_result_field' => false,
            'required' => true,
            'weight' => 2,
            'title' => [
                'fr' => 'Valeur actuelle',
            ],
            'description' => [
                'fr' => '',
            ],
            'widget' => [
                'type' => BridgeContentType::NUMBER_WIDGET,
                'settings' => [
                    'placeholder' => '',
                ],
                'weight' => 2,
            ],
            'type' => BridgeContentType::FLOAT_FIELD,
            'settings' => [
                'cardinality' => 1,
            ],
        ],
        // Annual objective
        'annual_objective' => [
            'name' => 'annual_objective',
            'searchable' => false,
            'translatable' => false,
            'default' => 0,
            'search_result_field' => false,
            'required' => true,
            'weight' => 4,
            'title' => [
                'fr' => 'Objectif annuel',
            ],
            'description' => [
                'fr' => '',
            ],
            'widget' => [
                'type' => BridgeContentType::NUMBER_WIDGET,
                'settings' => [
                    'placeholder' => '',
                ],
                'weight' => 4,
            ],
            'type' => BridgeContentType::FLOAT_FIELD,
            'settings' => [
                'cardinality' => 1,
            ],
        ],
        // Midyear objective
        'midyear_objective' => [
            'name' => 'midyear_objective',
            'searchable' => false,
            'translatable' => false,
            'default' => 0,
            'search_result_field' => false,
            'required' => false,
            'weight' => 3,
            'title' => [
                'fr' => 'Objectif mi-annuel',
            ],
            'description' => [
                'fr' => '',
            ],
            'widget' => [
                'type' => BridgeContentType::NUMBER_WIDGET,
                'settings' => [
                    'placeholder' => '',
                ],
                'weight' => 3,
            ],
            'type' => BridgeContentType::FLOAT_FIELD,
            'settings' => [
                'cardinality' => 1,
            ],
        ],
    ];
    public function up(): void
    {
        $fieldNames = ['annual_objective', 'midyear_objective', 'current_value'];
        $contents = [];
        $models = \Inside\Content\Models\Contents\CompanyStatistics::all();

        $bridgeContentType = new BridgeContentType();
        $bridgeContent = new BridgeContent();

        foreach ($models as $model) {
            $content = [
                'type' => 'node',
                'bundle' => 'company_statistics',
                'uuid' => $model->uuid,
            ];

            foreach ($fieldNames as $fieldName) {
                $content[$fieldName] = $model->{$fieldName};
            }

            $contents[] = $content;
        }

        foreach ($fieldNames as $fieldName) {
            $bridgeContentType->contentTypeDeleteField('node', 'company_statistics', $fieldName);
            $bridgeContentType->contentTypeCreateField('company_statistics', $fieldName, $this->fields[$fieldName], $this->fields[$fieldName]['weight']);
        }

        Artisan::call('models:rebuild');

        foreach ($contents as $content) {
            $bridgeContent->contentUpdate('company_statistics', $content);
        }
    }

    public function down(): void
    {
    }
}
