<?php

use Illuminate\Database\Migrations\Migration;
use Inside\Host\Bridge\BridgeContentType;

class AddBannerFieldToCustomPage extends Migration
{
    public function up(): void
    {
        $bridge = new BridgeContentType();

        $bridge->contentTypeCreateOrUpdateField(
            'custom',
            'banner',
            [
                'name'                  => 'banner',
                'searchable'            => false,
                'translatable'          => false,
                'default'               => null,
                'search_result_field'   => false,
                'required'              => false,
                'weight'                => 4,
                'title'                 => [
                    'fr' => 'Bannière',
                ],
                'description'           => [
                    'fr' => '',
                ],
                'widget'                => [
                    'type'      => BridgeContentType::IMAGE_WIDGET,
                    'settings'  => [
                        'progress_indicator'  => 'throbber',
                        'preview_image_style' => 'thumbnail',
                    ],
                    'weight'    => 4
                ],
                'type'                  => BridgeContentType::IMAGE_FIELD,
                'settings'              => [
                    'uri_scheme'      => 'public',
                    'default_image'   => [
                        'uuid'    => '',
                        'alt'     => '',
                        'title'   => '',
                        'width'   => null,
                        'height'  => null,
                    ],
                    'target_type'     => 'file',
                    'display_field'   => false,
                    'display_default' => false,
                    'cardinality'     => 1,
                ],
            ]
        );
    }
}
