<?php

use Illuminate\Database\Migrations\Migration;
use Inside\Database\Migrations\HasConsole;
use Inside\Content\Models\Contents\Users;
use Inside\Host\Bridge\BridgeContent;

class RemoveFonctionFieldValueForExternalUsers extends Migration
{
    use HasConsole;

    public function up(): void
    {
        $users = Users::query()->where('is_external', true)->get();
        $bridge = new BridgeContent();

        $currentUserIndex = 1;
        $nbrOfExternalUsers = count($users);
        foreach ($users as $user) {
            $this->writeln('[' . $currentUserIndex++ . '/' . $nbrOfExternalUsers . '] Updating user ' . $user->email);

            $bridge->contentUpdate('users', [
                'uuid_host' => $user->uuid_host,
                'function' => '',
            ]);
        }
    }
}
