<?php

use Illuminate\Database\Migrations\Migration;
use Inside\Content\Facades\DynamicClass;
use Inside\Database\Migrations\HasConsole;
use Inside\Host\Bridge\BridgeContentType;
use Inside\Host\Migrations\CreateContentTypes;

class AddLinkFieldsToSpaces extends Migration
{
    use CreateContentTypes;
    use HasConsole;

    /** @var array */
    protected $groups = [
        [
            'name' => 'space_header_links',
            'title' => 'Liens',
            'weight' => 100,
        ],
    ];

    public function up(): void
    {
        DynamicClass::disableRebuildAutoLoad();

        $this->bootUp(__FILE__, 'add_links_to_spaces_fields');

        foreach ($this->groups as $group) {
            $this->write('Ajout du fieldset <fg=cyan>'.$group['title'].'</>');
            $this->writeResult(
                $this->getBridge()->createOrUpdateFieldGroup(
                    'spaces',
                    $group['name'],
                    [
                        'fr' => $group['title'],
                    ],
                    $group['weight']
                )
            );
        }

        for ($i = 1; $i < 5; $i++) {
            $fieldOptions = $this->getFieldOptions($i);
            $this->getBridge()->contentTypeCreateOrUpdateField('spaces', $fieldOptions['name'], $fieldOptions);
        }

        $this->finishUp();

        DynamicClass::enableRebuildAutoLoad();
        $this->call('models:rebuild');
    }


    protected function getFieldOptions(int $number): array
    {
        return [
            'type' => BridgeContentType::TEXT_FIELD,
            'name' => 'space_link'.$number,
            'searchable' => false,
            'translatable' => false,
            'search_result_field' => false,
            'required' => false,
            'title' => [
                'fr' => 'Lien '.$number,
            ],
            'settings' => [
                'cardinality' => 1,
                'max_length' => 255
            ],
            'widget' => [
                'type' => BridgeContentType::INSIDE_LINK_WIDGET,
                'settings' => [
                    'size' => 250,
                    'placeholder' => '',
                ],
                'group' => 'space_header_links',
                'weight' => (100+$number),
            ],
        ];
    }
}
