<?php

use Illuminate\Database\Migrations\Migration;
use Inside\Content\Facades\DynamicClass;
use Inside\Database\Migrations\HasConsole;
use Inside\Host\Bridge\BridgeContentType;
use Inside\Host\Migrations\CreateContentTypes;

class AddNewUserFields8010 extends Migration
{
    use CreateContentTypes;
    use HasConsole;

    /** @var array */
    protected $fields = [
        [
            'type'                => BridgeContentType::TEXT_FIELD,
            'name'                => 'mobile_phone',
            'searchable'          => true,
            'translatable'        => false,
            'editable'            => true,
            'search_result_field' => false,
            'required'            => false,
            'title'               => [
                'fr' => 'Téléphone mobile',
            ],
            'settings'            => [
                'cardinality' => 1,
                'max_length' => 255
            ],
            'widget'              => [
                'type'     => BridgeContentType::TEXT_WIDGET,
                'settings' => [
                    'size' => 60,
                    'placeholder' => '',
                ],
                'group'    => 'profile',
                'weight'   => 9,
            ],
        ],
        [
            'type'                => BridgeContentType::TEXT_FIELD,
            'name'                => 'finished_project_1',
            'searchable'          => true,
            'translatable'        => false,
            'editable'            => true,
            'search_result_field' => false,
            'required'            => false,
            'title'               => [
                'fr' => 'Projet 1',
            ],
            'settings'            => [
                'cardinality' => 1,
                'max_length' => 255
            ],
            'widget'              => [
                'type'     => BridgeContentType::TEXT_WIDGET,
                'settings' => [
                    'size' => 60,
                    'placeholder' => '',
                ],
                'group'    => 'finished_projects',
                'weight'   => 56,
            ],
        ],
        [
            'type'                => BridgeContentType::TEXT_FIELD,
            'name'                => 'finished_project_2',
            'searchable'          => true,
            'translatable'        => false,
            'editable'            => true,
            'search_result_field' => false,
            'required'            => false,
            'title'               => [
                'fr' => 'Projet 2',
            ],
            'settings'            => [
                'cardinality' => 1,
                'max_length' => 255
            ],
            'widget'              => [
                'type'     => BridgeContentType::TEXT_WIDGET,
                'settings' => [
                    'size' => 60,
                    'placeholder' => '',
                ],
                'group'    => 'finished_projects',
                'weight'   => 57,
            ],
        ],
        [
            'type'                => BridgeContentType::TEXT_FIELD,
            'name'                => 'finished_project_3',
            'searchable'          => true,
            'translatable'        => false,
            'editable'            => true,
            'search_result_field' => false,
            'required'            => false,
            'title'               => [
                'fr' => 'Projet 3',
            ],
            'settings'            => [
                'cardinality' => 1,
                'max_length' => 255
            ],
            'widget'              => [
                'type'     => BridgeContentType::TEXT_WIDGET,
                'settings' => [
                    'size' => 60,
                    'placeholder' => '',
                ],
                'group'    => 'finished_projects',
                'weight'   => 58,
            ],
        ],
        [
            'type'                => BridgeContentType::TEXT_FIELD,
            'name'                => 'finished_project_4',
            'searchable'          => true,
            'translatable'        => false,
            'editable'            => true,
            'search_result_field' => false,
            'required'            => false,
            'title'               => [
                'fr' => 'Projet 4',
            ],
            'settings'            => [
                'cardinality' => 1,
                'max_length' => 255
            ],
            'widget'              => [
                'type'     => BridgeContentType::TEXT_WIDGET,
                'settings' => [
                    'size' => 60,
                    'placeholder' => '',
                ],
                'group'    => 'finished_projects',
                'weight'   => 59,
            ],
        ],
        [
            'type'                => BridgeContentType::TEXT_FIELD,
            'name'                => 'finished_project_5',
            'searchable'          => true,
            'translatable'        => false,
            'editable'            => true,
            'search_result_field' => false,
            'required'            => false,
            'title'               => [
                'fr' => 'Projet 5',
            ],
            'settings'            => [
                'cardinality' => 1,
                'max_length' => 255
            ],
            'widget'              => [
                'type'     => BridgeContentType::TEXT_WIDGET,
                'settings' => [
                    'size' => 60,
                    'placeholder' => '',
                ],
                'group'    => 'finished_projects',
                'weight'   => 60,
            ],
        ],
        [
            'name' => 'other_location',
            'searchable' => false,
            'translatable' => false,
            'search_result_field' => true,
            'required' => false,
            'weight' => 0,
            'editable' => true,
            'title' => [
                'fr' => 'Autre localisation',
            ],
            'widget' => [
                'type' => BridgeContentType::STRING_WIDGET,
                'settings' => [
                    'size' => 60,
                    'placeholder' => '',
                ],
                'group' => 'office',
                'weight' => 101,
            ],
            'type' => BridgeContentType::TEXT_FIELD,
            'settings' => [
                'max_length' => 255,
                'is_ascii' => false,
                'case_sensitive' => false,
                'cardinality' => 1,
            ],
        ],
    ];

    /** @var array */
    protected $groups = [
        [
            'name' => 'projects',
            'title' => 'Projets En cours',
            'weight' => 50,
        ],
        [
            'name' => 'finished_projects',
            'title' => 'Projets Terminés',
            'weight' => 55
        ],
        [
            'name' => 'office',
            'title' => 'Autre localisation (Bureau)',
            'weight' => 100,
        ],
    ];

    public function up(): void
    {
        DynamicClass::disableRebuildAutoLoad();

        $this->bootUp(__FILE__, 'add_news_user_fields');

        foreach ($this->groups as $group) {
            $this->write('Ajout du fieldset <fg=cyan>' . $group['title'] . '</>');
            $this->writeResult(
                $this->getBridge()->createOrUpdateFieldGroup(
                    'users',
                    $group['name'],
                    [
                        'fr' => $group['title'],
                    ],
                    $group['weight']
                )
            );
        }

        foreach ($this->fields as $field) {
            $this->bridge->contentTypeCreateOrUpdateField('users', $field['name'], $field);
        }

        $this->finishUp();

        DynamicClass::enableRebuildAutoLoad();
        $this->call('models:rebuild');
    }
}
