<?php

use Illuminate\Database\Migrations\Migration;
use Inside\Content\Facades\DynamicClass;
use Inside\Content\Models\Contents\Users;
use Inside\Database\Migrations\HasConsole;
use Inside\Host\Bridge\BridgeContent;
use Inside\Host\Bridge\BridgeContentType;
use Inside\Host\Migrations\CreateContentTypes;

class AddNewUserFields7943 extends Migration
{
    use CreateContentTypes;
    use HasConsole;

    /** @var array */
    protected $fields = [
        [
            'name' => 'is_external',
            'searchable' => true,
            'translatable' => false,
            'search_result_field' => false,
            'required' => false,
            'weight' => 0,
            'title' => [
                'fr' => 'Externe',
            ],
            'widget' => [
                'type' => BridgeContentType::BOOLEAN_CHECKBOX_WIDGET,
                'settings' => [
                    'display_label' => true,
                ],
                'weight' => 0,
            ],
            'type' => BridgeContentType::BOOLEAN_FIELD,
            'settings' => [
                'cardinality' => 1,
            ],
            'default' => false,
        ],
        [
            'name' => 'prestation_manager',
            'searchable' => false,
            'translatable' => false,
            'search_result_field' => false,
            'required' => false,
            'weight' => 1,
            'editable' => true,
            'title' => [
                'fr' => 'Rechercher une personne',
            ],
            'widget' => [
                'type' => BridgeContentType::AUTOCOMPLETE_WIDGET,
                'settings' => [],
                'weight' => 131,
                'group' => 'prestation_manager',
            ],
            'type' => BridgeContentType::REFERENCE_FIELD,
            'settings' => [
                'target_type' => 'users',
                'cardinality' => 1,
            ],
        ],
    ];

    /** @var array */
    protected $groups = [
        [
            'name' => 'prestation_manager',
            'title' => 'Responsable de prestation',
            'weight' => 130,
        ],
    ];

    public function up(): void
    {
        DynamicClass::disableRebuildAutoLoad();

        $this->bootUp(__FILE__, 'add_news_user_fields');

        foreach ($this->groups as $group) {
            $this->write('Ajout du fieldset <fg=cyan>' . $group['title'] . '</>');
            $this->writeResult(
                $this->getBridge()->createOrUpdateFieldGroup(
                    'users',
                    $group['name'],
                    [
                        'fr' => $group['title'],
                    ],
                    $group['weight']
                )
            );
        }

        foreach ($this->fields as $field) {
            $this->bridge->contentTypeCreateOrUpdateField('users', $field['name'], $field);
        }

        $this->finishUp();

        DynamicClass::enableRebuildAutoLoad();
        $this->call('models:rebuild');

        $users = Users::query()->where('is_external', null)->get();

        $bridge = new BridgeContent();

        $this->writeln('Updating is_external field on ' . count($users) . ' users');
        $i = 1;
        foreach ($users as $user) {
            $company = $user->company->where('title', 'Sodern')->first();
            $external = (!$company || count($company) === 0);

            $this->writeln('[' . $i++ . '/' . count($users) . '] Updating ' . ($external ? 'external' : 'internal') . ' user ' . $user->email);

            $bridge->contentUpdate('users', [
                'uuid_host' => $user->uuid_host,
                'is_external' => $external,
            ]);
        }
    }
}
