<?php

use Illuminate\Database\Migrations\Migration;
use Inside\Dms\Facades\Dms;
use Inside\Host\Bridge\BridgeContentType;
use Inside\Host\Migrations\CreateContentTypes;

class CreateSpaceDmsLinkContentType extends Migration
{
    use CreateContentTypes;

    /** @var array */
    protected $spaceDmsContentTypes = [
        'space_folders',
        'space_documents',
    ];

    public function up(): void
    {
        $this->bootUp(__FILE__, 'dms_link');

        // Corriger la configuration de la ged
        foreach ($this->spaceDmsContentTypes as $type) {
            $this->getConsole()->write('Correction des paramètres de <fg=cyan>' . $type . '</fg=cyan>');
            $this->getBridge()->updateContentTypeOptions(
                $type,
                [
                    'searchable'        => 1,
                    'permission_type'   => 'content',
                    'aliasable'         => 0,
                    'permissible'       => 1,
                    'categorizable'     => 1,
                    'global_searchable' => 1,
                ]
            );
            $this->getConsole()->writeln(' <fg=green>✔</fg=green>');
        }

        /** @var array $config */
        $config             = Dms::getContentTypeConfig('space_');
        $config['fields'][] = [
            'name'                => 'spaces',
            'searchable'          => false,
            'translatable'        => false,
            'default'             => [],
            'search_result_field' => false,
            'required'            => true,
            'weight'              => 5,
            'title'               => [
                'fr' => 'Espaces',
            ],
            'description'         => [
                'fr' => '',
            ],
            'widget'              => [
                'type'     => BridgeContentType::AUTOCOMPLETE_WIDGET,
                'settings' => [],
                'weight'   => 5,
                'group'    => 'group_advanced_options',
            ],
            'type'                => BridgeContentType::REFERENCE_FIELD,
            'settings'            => [
                'target_type' => ['spaces'],
                'cardinality' => -1,
            ],
        ];
        $this->getBridge()->contentTypeUpdateOrCreate('space_dms_link', $config['options'], $config['fields']);

        $this->finishUp();
    }
}
