<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Support\Facades\Artisan;
use Inside\Content\Facades\Schema;
use Inside\Content\Models\Contents\Users;
use Inside\Host\Bridge\BridgeContent;
use Inside\Host\Migrations\CreateContentTypes;
use Inside\Content\Facades\DynamicClass;

class CreateInsideHeaderPageContent extends Migration
{
    use CreateContentTypes;
    public function up(): void
    {
        DynamicClass::disableRebuildAutoLoad();
        $this->bootUp(__FILE__, 'Inside Header Page Content type');

        $this->migrateContent('header_cta', true, 'sections');
        $this->migrateContent('header_file', true, 'sections');
        $this->migrateContent('page_headers', true);

        $this->finishUp();
        DynamicClass::enableRebuildAutoLoad();
        $this->call('models:rebuild');
    }

    public function down(): void
    {
        $this->bootDown(__FILE__);
        $this->finishDown();
    }
}
