<?php

use Illuminate\Database\Migrations\Migration;
use Inside\Authentication\Models\User;
use Inside\Content\Events\ContentCreatedEvent;
use Inside\Content\Models\Contents\Events;
use Inside\Notify\Events\CustomNotificationEvent;
use Inside\Notify\Models\NotificationSubscriber;
use Inside\Notify\Models\NotificationType;
use Inside\Notify\Models\NotificationTypeRole;
use Inside\Permission\Models\Role;

class CreateEventsNotificationTypes extends Migration
{
    public function up(): void
    {
        $notificationTypes = collect();

        $notificationTypes[] = NotificationType::firstOrCreate(
            [
                'via'       => 'web',
                'default'   => true,
                'event'     => ContentCreatedEvent::class,
                'model'     => Events::class,
                'type'      => 'global',
                'action'    => 'create',
                'condition' => 'status:1',
                'multiple'  => false,
                'language'  => false,
                'profile'   => false,
                'role'      => false,
            ],
            [
                'data' => [
                    'title'       => 'notifications.content.events.created.title',
                    'description' => 'notifications.content.events.created.description',
                    'icon'        => 'events',
                    'text'        => 'notifications.content.events.created.text',
                    'fields'      => ['title'],
                ],
            ]
        );

        $notificationTypes[] = NotificationType::firstOrCreate(
            [
                'via'       => 'web',
                'default'   => true,
                'event'     => CustomNotificationEvent::class,
                'model'     => Events::class,
                'type'      => 'global',
                'action'    => 'warn',
                'condition' => 'status:1',
                'multiple'  => false,
                'language'  => false,
                'profile'   => false,
                'role'      => true,
            ],
            [
                'data' => [
                    'title'       => 'notifications.content.events.starting.title',
                    'description' => 'notifications.content.events.starting.description',
                    'icon'        => 'events',
                    'text'        => 'notifications.content.events.starting.text',
                    'fields'      => ['title'],
                ],
            ]
        );

        $authenticatedRole = Role::where('name', 'authenticated')->first();
        $notificationTypes->each(
            function ($type) use ($authenticatedRole) {
                NotificationSubscriber::where('notification_type_id', $type->id)->delete();
                // Subscribe existant users
                User::all()->each(
                    function ($user) use ($type) {
                        NotificationSubscriber::create(
                            [
                                'user_uuid'            => $user->uuid,
                                'notification_type_id' => $type->id,
                            ]
                        );
                    }
                );
                if ($type->role) {
                    NotificationTypeRole::where('notification_type_id', $type->id)->delete();
                    NotificationTypeRole::create(
                        [
                            'notification_type_id' => $type->id,
                            'role_id'              => $authenticatedRole->id,
                        ]
                    );
                }
            }
        );
    }
}
