<?php

use Inside\Host\Migrations\CreateContentTypes;
use Inside\Notify\Migrations\ReportMigration;

class SubscribeCommentReportNotification extends ReportMigration
{
    use CreateContentTypes;

    public function up(): void
    {
        $output = $this->getConsole();

        $output->write("<info>Réinscription des administrateurs aux notifications de report de commentaire.s.</info>");

        $this->registerReport(
            ['super_administrator'],
            'comments',
            true,
            true,
            'ROOT_RELATION:news,events,launches,contracts'
        );

        $output->writeln(' <fg=green>✔</fg=green>');
    }

    public function down(): void
    {
    }
}
