<?php

use Illuminate\Database\Migrations\Migration;
use Inside\Notify\Models\NotificationType;

class AddIdeaWebNotitificationType extends Migration
{
    public function up(): void
    {
        NotificationType::firstOrCreate(
            [
                'via'       => 'web',
                'default'   => true,
                'event'     => null,
                'model'     => null,
                'action'    => 'ideabox',
                'condition' => null,
                'multiple'  => true,
                'language'  => false,
                'profile'   => false,
            ],
            [
                'data' => [
                    'title'       => 'notifications.isod.web.<notification_name>.title',
                    'description' => 'notifications.isod.web.<notification_name>.description',
                    'icon'        => 'ideabox',
                    'text'        => 'notifications.isod.web.<notification_name>.text',
                    'fields'      => ['title'],
                ],
            ]
        );
    }

    public function down(): void
    {
    }
}
