<?php

use Illuminate\Database\Migrations\Migration;
use Inside\Host\Bridge\BridgeContentType;
use Symfony\Component\Console\Formatter\OutputFormatterStyle;
use Symfony\Component\Console\Output\ConsoleOutput;

class AddLdapDnOnUsersTable extends Migration
{
    public function up(): void
    {
        $output      = new ConsoleOutput();
        $outputStyle = new OutputFormatterStyle('white', 'green', ['bold', 'blink', 'underscore']);
        $output->getFormatter()->setStyle('module', $outputStyle);
        $outputStyle = new OutputFormatterStyle('yellow', 'default', ['bold', 'blink', 'underscore']);
        $output->getFormatter()->setStyle('class', $outputStyle);

        $output->writeln("<info>Début de Maj Sodern</info> <module>isod-back</module>");

        $bridge = new BridgeContentType();

        // Add lda_dn field to users
        $users_ldap_dn = include __DIR__ . '/fields/users/ldap_dn.php';

        try {
            $output->writeln(
                "<info>Ajout d'un champ</info> <class>ldap_dn</class><info> dans la fiche utilisateur</info>"
            );
            $bridge->contentTypeCreateOrUpdateField(
                'users',
                'ldap_dn',
                $users_ldap_dn
            );
            $output->writeln("<comment>Champ <class>ldap_dn</class> correctement créé</comment> ");
        } catch (\Exception $e) {
            dd($e);
        }
        $output->writeln("<comment>Tâche(s) effectuée(s) avec succès</comment>");
    }

    public function down(): void
    {
    }
}
