<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateSodernGameInformationsTable extends Migration
{
    public function up(): void
    {
        Schema::create('inside_sodern_game_informations', function (Blueprint $table) {
            $table->bigIncrements('id');
            $table->char('user_uuid', 36)->collate('utf8')->unique()->comment('Correspond to user uuid');
            $table->enum('answer1', [0,1,2,3])->nullable()->default(null);
            $table->enum('answer2', [0,1,2,3])->nullable()->default(null);
            $table->enum('answer3', [0,1,2,3])->nullable()->default(null);
            $table->enum('answer4', [0,1,2,3])->nullable()->default(null);
            $table->enum('answer5', [0,1,2,3])->nullable()->default(null);
            $table->enum('answer6', [0,1,2,3])->nullable()->default(null);
            $table->enum('answer7', [0,1,2,3])->nullable()->default(null);
            $table->enum('answer8', [0,1,2,3])->nullable()->default(null);
            $table->timestamps();
        });
        Schema::table('inside_sodern_game_informations', function (Blueprint $table) {
            $table->foreign('user_uuid', 'isgi_user_uuid_foreign')
                  ->references('uuid')->on('inside_content_users')
                  ->onDelete('cascade');
        });
    }

    public function down(): void
    {
        Schema::table('inside_sodern_game_informations', function (Blueprint $table) {
            $table->dropForeign('isgi_user_uuid_foreign');
        });
        Schema::drop('inside_sodern_game');
    }
}
