<?php

use Inside\Host\Bridge\BridgeContentType;

$weight = 0;
return [
    'options' => [
        'name'              => 'page_headers',
        'aliasable'         => false,
        'searchable'        => false,
        'global_searchable' => false,
        'permissible'       => false,
        'categorizable'     => false,
        'translatable'      => false,
        'deletion_strategy' => 'none',
        'title'             => [
            'fr' => 'Entête de page',
        ],
    ],
    'fields'  => [
        // Slug
        [
            'name'        => 'page_header_slug',
            'default'     => '',
            'required'    => true,
            'weight'              => $weight++,
            'title'       => [
                'fr' => 'Slug de la page',
            ],
            'description' => [
                'fr' => 'Il faut indiquer le slug de la page où devra apparaitre l\'entête.',
            ],
            'widget'      => [
                'type'     => BridgeContentType::TEXT_WIDGET,
                'settings' => [],
            ],
            'type'        => BridgeContentType::TEXT_FIELD,
            'settings'    => [
                'max_length'     => 255,
                'is_ascii'       => false,
                'case_sensitive' => false,
                'cardinality'    => 1,
            ],
        ],
        // Image
        [
            'name'                => 'page_header_image',
            'searchable'          => false,
            'translatable'        => false,
            'default'             => null,
            'search_result_field' => false,
            'required'            => false,
            'weight'              => $weight++,
            'title'               => [
                'fr' => 'Image',
            ],
            'description'         => [
                'fr' => '',
            ],
            'widget'              => [
                'type'     => BridgeContentType::IMAGE_WIDGET,
                'settings' => [
                    'progress_indicator'  => 'throbber',
                    'preview_image_style' => 'thumbnail',
                ],
            ],
            'type'                => BridgeContentType::IMAGE_FIELD,
            'settings'            => [
                'uri_scheme'      => 'public',
                'default_image'   => [
                    'uuid'   => '',
                    'alt'    => '',
                    'title'  => '',
                    'width'  => null,
                    'height' => null,
                ],
                'target_type'     => 'file',
                'display_field'   => false,
                'display_default' => false,
                'cardinality'     => 1,
            ],
        ],
        // Description
        [
            'type'                => BridgeContentType::WYSIWYG_FIELD,
            'name'                => 'page_header_description',
            'searchable'          => false,
            'translatable'        => false,
            'search_result_field' => false,
            'required'            => true,
            'weight'              => $weight++,
            'title'               => [
                'fr' => 'Description',
            ],
            'description'         => [
                'fr' => '',
            ],
            'settings'            => [],
            'widget'              => [
                'type'     => BridgeContentType::WYSIWYG_WIDGET,
                'settings' => [],
            ],
        ],
        // Content
        [
            'name'                => 'content',
            'searchable'          => false,
            'translatable'        => false,
            'default'             => [],
            'search_result_field' => false,
            'required'            => false,
            'weight'              => $weight++,
            'title'               => [
                'fr' => 'Liens',
            ],
            'description'         => [
                'fr' => '',
            ],
            'widget'              => [
                'type'     => BridgeContentType::SECTION_WIDGET,
                'settings' => [
                    'title'                  => 'Paragraphe',
                    'title_plural'           => 'Paragraphs',
                    'edit_mode'              => 'closed',
                    'add_mode'               => 'dropdown',
                    'form_display_mode'      => 'default',
                    'default_paragraph_type' => '_none',
                ],
            ],
            'type'                => BridgeContentType::SECTION_FIELD,
            'settings'            => [
                'target_type' => ['header_cta', 'header_file'],
                'cardinality' => -1,
            ],
        ],
    ],
];
