<?php

use Illuminate\Support\Facades\Auth;
use Inside\Authentication\Models\User;
use Inside\Content\Models\Contents\Ideas;
use Inside\ISOD\Facades\IdeasBox;

return [
    'custom_permissions' => [
        /**
         * This is a custom callback when permission fails, we grant the possibility
         * to allow something
         */
        function (string $action, string $type, $uuid): bool {
            // Only custom for ideas
            if ($type != 'ideas' || $uuid === null) {
                return false;
            }
            if (!in_array($action, ['update', 'delete'])) {
                return false;
            }
            // Get content
            $idea = Ideas::find($uuid);
            if (!$idea) {
                return false;
            }
            $user = Auth::guard('api')->user();
            if (!$user instanceof User) {
                return false;
            }
            $ideaData = $idea->toArray();
            $ideaData['authors']['uuid'] = $idea['author'];
            $ideaData['idea_collaborator']['uuid'] = $idea->ideaCollaborator->first()->uuid ?? null;

            return IdeasBox::canEditAndDelete($user->permission, $ideaData);
        },
    ],
];
