<?php

namespace Inside\ISOD\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\HasMany;

/**
 * @property int $id
 * @property string $title
 * @property array $softwares
 */
class Equipment extends Model
{
    protected $table = 'inside_sodern_equipments';
    public $timestamps = false;
    protected $casts = ['id' => 'string'];

    public function softwares(): HasMany
    {
        return $this->hasMany(Software::class, 'equipment_id', 'id');
    }
}
