<?php

namespace Inside\ISOD\Listeners;

use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Support\Facades\Log;
use Illuminate\Support\Facades\Notification;
use Inside\Authentication\Models\User;
use Inside\Content\Events\ContentUpdatingEvent;
use Inside\Content\Models\Contents\Ideas;
use Inside\ISOD\Facades\IdeasBox;
use Inside\ISOD\Notifications\CollaboratorAssignedOnYourComplexeIdea;
use Inside\ISOD\Notifications\ComplexeIdeaDoneAndValidated;
use Inside\ISOD\Notifications\YourComplexeIdeaIsDoneAndValidated;

class WorkDoneAndValidated
{
    /**
     * @param mixed $event
     * @return void
     */
    public function handle($event): void
    {
        $idea = $event->getSubject();

        // On entered work_validated
        if (get_class($idea) === Ideas::class) {
            $author = User::find($idea->author);
            Notification::send($author, new YourComplexeIdeaIsDoneAndValidated($idea));
            $collaborator = $idea->ideaCollaborator ;
            Log::debug('[WorkDoneAndNeedValidation::handle]');
            if ($collaborator && $collaborator->count() == 1) {
                $collaborator = User::find($collaborator->first()->uuid);
                Notification::send($collaborator, new ComplexeIdeaDoneAndValidated($idea));
            }
        }
    }
}
