<?php

namespace Inside\ISOD\Listeners;

use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Support\Facades\Log;
use Illuminate\Support\Facades\Notification;
use Inside\Authentication\Models\User;
use Inside\Content\Models\Contents\Ideas;
use Inside\ISOD\Notifications\ComplexeIdeaDoneAndNeedValidation;

class WorkDoneAndNeedValidation
{
    /**
     * @param mixed $event
     * @return void
     */
    public function handle($event): void
    {
        $idea = $event->getSubject();

        // On entered work_in_review
        if (get_class($idea) === Ideas::class) {
            Log::debug('[WorkDoneAndNeedValidation::handle]');

            $manager = $idea->authors->operationalManager;
            if ($manager !== null && $manager->isNotEmpty()) {
                $manager = User::find($manager->first()->uuid);
                Notification::send($manager, new ComplexeIdeaDoneAndNeedValidation($idea));
            }
        }
    }
}
