<?php

namespace Inside\ISOD\Listeners;

use Illuminate\Support\Facades\Log;
use Inside\Notify\Models\NotificationSubscriber;
use Inside\Notify\Models\NotificationType;
use Inside\Permission\Events\RoleAttachedEvent;
use Inside\Permission\Events\RoleDetachedEvent;
use Inside\Permission\Models\Permission;
use Inside\Permission\Models\User;

class RegisterSodernUsersToMarketingNewsletterListener
{
    /** @var array */
    protected $notificationType = [
        'via'       => 'email',
        'default'   => false,
        'event'     => 'Inside\Content\Events\ContentCreatedEvent',
        'model'     => 'Inside\Content\Models\Contents\VeilleMarketing',
        'action'    => 'createOrUpdate',
        'condition' => 'status:1|test_email:',
        'multiple'  => false,
        'language'  => true,
        'profile'   => true,
    ];

    /**
     * @param mixed $event
     * @return void
     */
    public function handle($event): void
    {
        if ($event instanceof RoleAttachedEvent || $event instanceof RoleDetachedEvent) {
            /** @var User|null $user */
            $user = $event->user;
            if ($user) {
                $notificationType = NotificationType::where($this->notificationType)->first();
                if ($notificationType) {
                    if ($user->hasAnyRole('Sodern')) {
                        Log::debug('Subscribe user [' . $user->email . '] to newsletter Marketing');
                        NotificationSubscriber::firstOrCreate(
                            [
                                'user_uuid'            => $user->uuid,
                                'notification_type_id' => $notificationType->id,
                            ]
                        );
                    } else {
                        $subscription = NotificationSubscriber::where(
                            [
                                'user_uuid'            => $user->uuid,
                                'notification_type_id' => $notificationType->id,
                            ]
                        )->get();
                        if ($subscription->count() > 0) {
                            $subscription->each(fn (NotificationSubscriber $notif) => $notif->delete());
                            Log::debug('Unsubscribe user [' . $user->email . '] to newsletter Marketing');
                        }
                    }
                }
            }
        } elseif (isset($event->model->content_type) && ($event->model->content_type == 'users')) {
            // Get Permission User
            /** @var ?User $user */
            $user = User::find($event->model->uuid);
            if ($user) {
                $notificationType = NotificationType::where($this->notificationType)->first();
                if ($notificationType) {
                    if ($user->hasAnyRole('Sodern')) {
                        Log::debug('Subscribe user [' . $user->email . '] to newsletter Marketing');
                        NotificationSubscriber::firstOrCreate(
                            [
                                'user_uuid'            => $user->uuid,
                                'notification_type_id' => $notificationType->id,
                            ]
                        );
                    } else {
                        $subscription = NotificationSubscriber::where(
                            [
                                'user_uuid'            => $user->uuid,
                                'notification_type_id' => $notificationType->id,
                            ]
                        )->get();
                        if ($subscription->count() > 0) {
                            $subscription->each(fn (NotificationSubscriber $notif) => $notif->delete());
                            Log::debug('Unsubscribe user [' . $user->email . '] to newsletter Marketing');
                        }
                    }
                }
            }
        }
    }
}
