<?php

namespace Inside\ISOD\Listeners;

use Illuminate\Support\Facades\Log;
use Illuminate\Support\Facades\Notification;
use Inside\Authentication\Models\User;
use Inside\ISOD\Events\CollaboratorSetEvent;
use Inside\ISOD\Notifications\CollaboratorAssignedOnComplexeIdea;
use Inside\ISOD\Notifications\CollaboratorAssignedOnYourComplexeIdea;

class NotifyOnCollaboratorSet
{
    public function handle(CollaboratorSetEvent $event): void
    {
        Log::debug('[NotifyOnCollaboratorSet::handle] Collaborator set <'.$event->collaborator->email.'>');
        $idea   = $event->idea;
        $author = User::find($idea->author);
        Notification::send($author, new CollaboratorAssignedOnYourComplexeIdea($idea));
        if ($event->collaborator) {
            $collaborator = User::find($event->collaborator->uuid);
            Notification::send($collaborator, new CollaboratorAssignedOnComplexeIdea($idea));
        }
    }
}
