<?php

namespace Inside\ISOD\Listeners;

use Inside\Content\Events\ContentPublishedEvent;
use Inside\Content\Listeners\BaseContentListener;
use Inside\Content\Models\Contents\News;
use Inside\Host\Bridge\BridgeContent;

/**
 * Content published listener
 *
 * @category Class
 * @package  Inside\Content\Listeners
 * @author   Maecia <technique@maecia.com>
 * @license  http://www.gnu.org/copyleft/gpl.html GNU General Public License
 * @link     http://www.maecia.com/
 */
class ContentPublishedListener extends BaseContentListener
{
    public function handle(ContentPublishedEvent $event): void
    {
        $model = $event->model;

        if (class_to_type((string)get_class($model)) !== 'news') {
            return;
        }

        $model = call_user_func(get_class($model).'::find', $model->uuid);

        if (!$model->status || !$model->is_featured) {
            return;
        }

        $bridge = new BridgeContent();
        $maxFeaturedNews = config('news.max_featured_news');

        News::withoutEvents(
            function () use ($bridge, $maxFeaturedNews) {
                News::withoutGlobalScopes()
                    ->where('status', 1)
                    ->where('is_featured', 1)
                    ->orderBy('created_at', 'desc')
                    ->get()
                    ->skip($maxFeaturedNews)
                    ->each(fn (News $news) => $bridge->contentUpdate('news', [
                        'uuid' => $news->uuid,
                        'is_featured' => false,
                    ]));
            }
        );
    }
}
