<?php

namespace Inside\ISOD\Listeners;

use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Log;
use Illuminate\Support\Facades\Notification;
use Inside\Authentication\Models\User;
use Inside\Content\Models\Contents\Ideas;
use Inside\Content\Models\Contents\Users;
use Inside\Host\Bridge\BridgeContent;

class ComplexeIdeaRefused
{
    /**
     * @param mixed $event
     * @return void
     * @throws \Exception
     */
    public function handle($event): void
    {
        $idea = $event->getSubject();

        // entered idea_refused
        if (get_class($idea) === Ideas::class) {
            $author = User::find($idea->author);

            /** @var User $user */
            $user = Auth::user();
            $validator = Users::find($user->uuid);
            // Assign current user has validator
            if ($validator) {
                Log::debug('[ComplexeIdeaRefused::handle] Assign idea_validator <' . $validator->email . '>');
                $bridge = new BridgeContent();
                $bridge->contentUpdate(
                    'ideas',
                    [
                        'uuid'           => $idea->uuid,
                        'bundle'         => 'ideas',
                        'type'           => 'node',
                        'idea_validator' => [$validator->uuid],
                        'author'         => $idea->authors->uuid,
                    ]
                );
            }

            // Notify author
            Notification::send($author, new \Inside\ISOD\Notifications\ComplexeIdeaRefused($idea));
        }
    }
}
