<?php

namespace Inside\ISOD\Http\Middleware;

use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Lang;
use Inside\Content\Models\Contents\Users;
use Inside\ISOD\Facades\IdeasBox;
use Inside\Permission\Models\User;

class PrepareIdeasList extends IdeasMiddleware
{
    protected function patchRequest(Request $request): Request
    {
        $request = parent::patchRequest($request);

        if ($this->isModal) {
            return $request;
        }

        $inputs = $request->all();
        $inputs['fields'] = json_encode(
            [
                'uuid',
                'content_type',
                'title',
                'idea_type',
                'created_at',
                'idea_status',
                'admin',
                [
                    'authors' => [
                        'uuid',
                        'firstname',
                        'lastname',
                        'image',
                    ],
                ],
                [
                    'idea_collaborator' => [
                        'uuid',
                        'firstname',
                        'lastname',
                        'image',
                    ],
                ],
            ]
        );

        return $request->replace($inputs);
    }

    /**
     * @param Request $request
     * @param mixed $response
     * @param array $data
     * @return mixed
     */
    protected function patch(Request $request, $response, array $data = [])
    {
        if ($this->isModal) {
            return $response;
        }
        // Get $fields content
        /** @var array|null $content */
        $content = json_decode_response($response);
        if ($content === null || !isset($content['data']) || !is_array($content['data'])) {
            return $response;
        }

        /** @var \Inside\Authentication\Models\User $user */
        $user = Auth::user();
        /** @var User $me */
        $me = User::findOrFail($user->uuid);

        foreach ($content['data'] as &$data) {
            $hasPermission = $this->canEditAndDelete($me, $data);

            $data['admin']    = [
                'update' => $hasPermission,
                'delete' => $hasPermission,
            ];
            $data['services'] = $this->getAuthorServices($data);
            $data['status']   = $this->getStatusInfo($data);
        }

        set_response($response, $content);

        return $response;
    }
}
