<?php

namespace Inside\ISOD\Http\Middleware;

use Closure;
use Illuminate\Http\Request;
use Illuminate\Http\Response;
use Inside\Content\Models\Contents\Ideas;
use Inside\ISOD\Events\IdeaCreatedEvent;
use Inside\ISOD\Facades\IdeasBox;

class PrepareIdeasCreation
{
    /**
     * @param Request $request
     * @param Closure $next
     * @return Response|mixed
     */
    public function handle(Request $request, Closure $next)
    {
        $method = $request->getMethod();
        $path   = $request->path();
        if ($method === 'POST'
            && preg_match(
                '#^api/v1/content/ideas$#iD',
                $path
            ) > 0
        ) {
            $inputs                = $request->all();
            $inputs['title']       = trim($inputs['title']);
            $inputs['fields']      = [
                'uuid',
                'slug',
            ];
            $inputs['idea_status'] = IdeasBox::getInitialStatus();

            $response = $next($request->replace($inputs));
            if ($response instanceof Response) {
                /** @var array|null $content */
                $content = json_decode_response($response);
                if ($content !== null) {
                    $idea = Ideas::find($content['uuid']);
                    if ($idea) {
                        event(new IdeaCreatedEvent($idea));
                    }
                }
            }

            return $response;
        }

        return $next($request);
    }
}
