<?php

namespace Inside\ISOD\Http\Middleware;

use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Inside\Authentication\Models\User;
use Inside\Content\Models\Contents\Users;

class ManageMessageFieldsOnProfileForm extends CustomizeResponse
{
    protected $pathes = [
        'GET' => ['#api/v1/form/users/([\da-f]{8}-[\da-f]{4}-[\da-f]{4}-[\da-f]{4}-[\da-f]{12})$#iD'],
    ];

    /**
     * @param Request $request
     * @param mixed $response
     * @param array $data
     * @return mixed
     */
    protected function patch(Request $request, $response, array $data = [])
    {
        /** @var User|null $me */
        $me = Auth::user();

        // Get current content
        /** @var array|null $content */
        $content = json_decode_response($response);
        if ($content === null || !isset($content['data'])) {
            return $response;
        }

        if (!Auth::check() || !$me || $me->uuid !== $data[1]) {
            return $response;
        }

        // A RH ?
        $me = Users::findOrFail($me->uuid);

        $isRH = !is_null($me->reverseServices) ? $me->reverseServices->isNotEmpty() : false;

        $isManager = !is_null($me->reverseOperationalManager) ? $me->reverseOperationalManager->isNotEmpty() : false;

        $datas = collect($content['data']);

        $informationsKey = $datas->search(
            function ($field) {
                return isset($field['id']) && $field['id'] == 'group_profile';
            }
        );

        if ($informationsKey && isset($datas[$informationsKey]['fields'])) {
            if (!$isRH) {
                $key = collect($datas[$informationsKey]['fields'])->search(
                    function ($field) {
                        return isset($field['name']) && $field['name'] == 'rh_message';
                    }
                );
                if ($key) {
                    unset($content['data'][$informationsKey]['fields'][$key]);
                }
            }
            if (!$isManager) {
                $key = collect($datas[$informationsKey]['fields'])->search(
                    function ($field) {
                        return isset($field['name']) && $field['name'] == 'manager_message';
                    }
                );
                if ($key) {
                    unset($content['data'][$informationsKey]['fields'][$key]);
                }
            }
            $content['data'][$informationsKey]['fields'] = array_values($content['data'][$informationsKey]['fields']);
        }

        set_response($response, $content);

        return $response;
    }
}
