<?php

namespace Inside\ISOD\Http\Middleware;

use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Inside\Authentication\Models\User;
use Inside\Content\Models\Contents\Users;

class ManageExternalFieldsOnProfileForm extends CustomizeResponse
{
    protected $pathes = [
        'GET' => ['#api/v1/form/users/([\da-f]{8}-[\da-f]{4}-[\da-f]{4}-[\da-f]{4}-[\da-f]{12})$#iD'],
    ];

    /**
     * @param Request $request
     * @param mixed $response
     * @param array $data
     * @return mixed
     */
    protected function patch(Request $request, $response, array $data = [])
    {
        /** @var User|null $me */
        $me = Auth::user();

        // Get current content
        /** @var array|null $content */
        $content = json_decode_response($response);
        if ($content === null || !isset($content['data'])) {
            return $response;
        }

        if (!Auth::check() || !$me || $me->uuid !== $data[1]) {
            return $response;
        }

        $me = Users::findOrFail($me->uuid);

        $isExternal = $me->is_external;
        $datas = collect($content['data']);

        $fieldsToRemove = [
            'external' => [
                'group_profile' => ['function'],
                'complementary_roles' => 'all',
                'associative_roles' => 'all',
                'who_to_contact' => 'all',
            ],
            'internal' => [
                'prestation_manager' => 'all',
            ],
        ];

        $key = $isExternal ? 'external' : 'internal';

        foreach ($fieldsToRemove[$key] as $groupKey => $fields) {
            $informationsKey = $datas->search(
                function ($field) use ($groupKey) {
                    return isset($field['id']) && $field['id'] == $groupKey;
                }
            );

            if ($informationsKey && isset($datas[$informationsKey]['fields'])) {
                if (is_array($fields)) {
                    foreach ($fields as $fieldKey) {
                        $fieldToRemoveKey = collect($datas[$informationsKey]['fields'])->search(
                            function ($field) use ($fieldKey) {
                                return isset($field['name']) && $field['name'] == $fieldKey;
                            }
                        );

                        if ($fieldToRemoveKey !== false) {
                            unset($content['data'][$informationsKey]['fields'][$fieldToRemoveKey]);
                        }
                    }

                    $content['data'][$informationsKey]['fields'] = array_values($content['data'][$informationsKey]['fields']);
                } else {
                    unset($content['data'][$informationsKey]);
                }
            }
        }

        $content['data'] = array_values($content['data']);

        set_response($response, $content);

        return $response;
    }
}
