<?php

namespace Inside\ISOD\Http\Middleware;

use Illuminate\Http\Request;
use Illuminate\Support\Facades\Lang;
use Inside\Content\Models\Contents\Ideas;
use Inside\Content\Models\Contents\Users;
use Inside\ISOD\Facades\IdeasBox;
use Inside\Permission\Models\User;
use Symfony\Component\Workflow\Transition;

abstract class IdeasMiddleware extends CustomizeResponse
{
    protected $pathes = [
        'GET' => [
            'api/v1/content/ideas',
        ],
    ];

    /** @var bool */
    protected $isModal = false;

    protected function patchRequest(Request $request): Request
    {
        $inputs = $request->all();

        $filters = json_decode($inputs['filters'] ?? '{}', true);

        $this->isModal = isset($filters['uuid'])
            && preg_match(
                '/^[\da-f]{8}-[\da-f]{4}-[\da-f]{4}-[\da-f]{4}-[\da-f]{12}$/iD',
                $filters['uuid']
            ) > 0;

        return $request;
    }

    protected function canEditAndDelete(User $user, array $data): bool
    {
        return IdeasBox::canEditAndDelete($user, $data);
    }

    protected function getAuthorServices(array $data): array
    {
        $author = Users::findOrFail($data['authors']['uuid']);

        return [
            'data' => $author->services->transform(
                function ($service) {
                    return ['title' => $service->title];
                }
            ) ?? [],
        ];
    }

    protected function getStatusInfo(array $data, bool $withAllowedValues = false): array
    {
        $idea        = Ideas::find($data['uuid']);
        $workflow    = IdeasBox::getWorkflow()->get($idea);
        $transitions = $workflow->getEnabledTransitions($idea);
        $current     = [
            'value' => $data['idea_status'],
            'title' => Lang::get(
                'ideasbox.statuses.' . $data['idea_status'] . '.title'
            ),
            'color' => IdeasBox::getStatusColor($data['idea_status']),
        ];

        if (!$withAllowedValues) {
            return $current;
        }

        return array_merge(
            $current,
            [
                'allowed_values' => array_merge(
                    [$current],
                    array_map(
                        function (Transition $value) {
                            $toTitle  = $value->getTos()[0];

                            return [
                                'transition' => $value->getName(),
                                'value'      => $toTitle,
                                'title'      => Lang::get(
                                    'ideasbox.statuses.' . $toTitle . '.title'
                                ),
                                'color'      => IdeasBox::getStatusColor($toTitle),
                            ];
                        },
                        $transitions
                    )
                ),
            ]
        );
    }
}
