<?php

namespace Inside\ISOD\Http\Middleware;

use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Storage;
use Inside\Authentication\Models\User;
use Inside\Content\Models\Contents\Users;

class AddMessagesToWelcomeModal extends CustomizeResponse
{
    protected $pathes = [
        'GET' => [
            'api/v1/content/modal',
        ],
    ];

    protected function patch($request, $response, array $data = [])
    {
        // Get current content
        /** @var array|null $content */
        $content = json_decode_response($response);

        if ($content === null || !isset($content['data'])) {
            return $response;
        }
        $content['data'] = collect($content['data'])->transform(
            function ($modal) {
                if ($modal['class'] == 'welcome') {
                    /** @var User $user */
                    $user = Auth::user();
                    $me = Users::findOrFail($user->uuid);

                    // Get my rh
                    $rhOp = null;
                    if (($service = $me->services->first()) !== null) {
                        $rhOp = $service->operationalHr->first();
                    }

                    // get my op manager
                    $opManager = $me->operationalManager->first();

                    if ($rhOp) {
                        $modal['content'][] = [
                            'section_type' => 'responsible_message',
                            'type'         => 'hr_message',
                            'body'         => $rhOp->rh_message,
                            'image'        => asset(Storage::path($rhOp->image)),
                        ];
                    }
                    if ($opManager) {
                        $modal['content'][] = [
                            'section_type' => 'responsible_message',
                            'type'         => 'manager_message',
                            'body'         => $opManager->manager_message,
                            'image'        => asset(Storage::path($opManager->image)),
                        ];
                    }
                }
                return $modal;
            }
        );

        set_response($response, $content);

        return $response;
    }
}
