<?php

namespace Inside\ISOD\Http\Controllers;

use Illuminate\Auth\AuthenticationException;
use Illuminate\Support\Facades\Auth;
use Inside\Authentication\Models\User;
use Inside\ISOD\Models\Equipment;
use Laravel\Lumen\Routing\Controller;

class EquipmentController extends Controller
{
    public function list(): array
    {
        // Check super admin
        /** @var User|null $user */
        $user = Auth::user();

        if (!$user) {
            throw new AuthenticationException();
        }

        $equipments = Equipment::query()->where('user_uuid', $user->uuid)->with(['softwares' => function ($subquery) {
            $subquery->orderBy('title');
        }])->orderBy('title')->get();

        return [
            'data' => $equipments,
        ];
    }
}
