<?php

namespace Inside\ISOD\Game\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;
use Inside\Content\Models\Contents\Users;

/**
 * Class Informations
 *
 * @property-read \Inside\Content\Models\Contents\Users $user
 * @method static \Illuminate\Database\Eloquent\Builder|\Inside\ISOD\Game\Models\Informations newModelQuery()
 * @method static \Illuminate\Database\Eloquent\Builder|\Inside\ISOD\Game\Models\Informations newQuery()
 * @method static \Illuminate\Database\Eloquent\Builder|\Inside\ISOD\Game\Models\Informations query()
 * @OA\Schema (schema="Inside\ISOD\Game\Models\Informations",title="informations",type="object",description="Dynamic
 *            model generated by inside
 *            content",@OA\Property(property="user",title="user",type="\Inside\Content\Models\Contents\Users",description=""))
 */
class Informations extends Model
{
    protected $table = 'inside_sodern_game_informations';

    protected $fillable = [
        'user_uuid', // Easy association on create so we don't care if user is a content users, a permission user, ...
    ];

    protected $touches = [
        'user',
    ];

    /**
     *
     * @return \Illuminate\Database\Eloquent\Relations\BelongsTo
     */
    public function user(): belongsTo
    {
        return $this->belongsTo(Users::class, 'user_uuid', 'uuid');
    }
}
