<?php

namespace Inside\ISOD\Events;

use Illuminate\Support\Facades\Auth;
use Inside\Authentication\Models\User;
use Inside\Content\Models\Contents\Ideas;
use Illuminate\Queue\SerializesModels;

class IdeaCreatedEvent
{
    use SerializesModels;

    /** @var Ideas */
    public $idea;

    /** @var User */
    public $user;

    public function __construct(Ideas $idea)
    {
        $this->idea = $idea;
        /** @var User $user */
        $user = Auth::user();
        $this->user = $user;
    }
}
