<?php

namespace Inside\ISOD\Events;

use Illuminate\Support\Facades\Auth;
use Inside\Authentication\Models\User;
use Inside\Content\Models\Contents\Ideas;
use Inside\Content\Models\Contents\Users;

class CollaboratorSetEvent
{
    /** @var Ideas */
    public $idea;

    /** @var User */
    public $user;

    /** @var Users|null */
    public $collaborator;

    public function __construct(Ideas $idea, Users $collaborator)
    {
        $this->idea = $idea;
        /** @var User $user */
        $user = Auth::user();
        $this->user = $user;
        $this->collaborator = $collaborator;
    }
}
