<?php

namespace Inside\ISOD\Console\Commands;

use Illuminate\Console\Command;
use Inside\Content\Models\Contents\Ideas;
use Inside\ISOD\Facades\IdeasBox;
use Symfony\Component\Process\Process;
use Symfony\Component\Workflow\Dumper\GraphvizDumper;

class DumpIdeasBoxWorkflowCommand extends Command
{
    protected $signature = 'inside:dump:ideas-workflow';

    public function handle(): void
    {
        $idea = new Ideas();
        $workflow    = IdeasBox::getWorkflow()->get($idea);
        $definition = $workflow->getDefinition();

        $dumper = new GraphvizDumper();

        $dotCommand = ["dot", "-Tpng", "-o", "ideasbox.png"];

        $process = new Process($dotCommand);
        $process->setInput($dumper->dump($definition));
        $process->mustRun();
    }
}
