<?php

return [
    '_meta' => [
        'type' => 'newsletters',
        'fieldsPrefix' => ''
    ],
    'logo' => [
        'showLogo'  => true,
        'logoUrl'   => 'vendor/maecia/isod-back/resources/assets/img/newsletter/logo.png',
        'logoWidth' => 123,
        'showDate' => true
    ],
    'banner'       => [
        'backgroundImageUrl' => 'vendor/maecia/isod-back/resources/assets/img/newsletter/header.jpg',
        'backgroundColor' => '#fff'
    ],
    'introduction' => [
        'introductionFieldName' => 'body',
        'textColor' => '#2C3E50'
    ],
    'sections'     => [
        'featured'       => [
            'sectionTitleStrKey' => 'newsletter.news_title',
            'sectionType' => 'news',
            'types' => ['news', 'forms'],
            'dateFormat' => '%d %B %Y',
            'showCategoryTitle' => false,
            'defaultImageUrl' => 'vendor/maecia/isod-back/resources/assets/img/newsletter/default.jpg',
            'link' => [
                'sectionLinkUrl'  => 'actualites',
                'sectionTextColor' => '#8183c2',
                'sectionLinkStrKey' => 'newsletter.news_link'
            ],
        ],
        'contracts'       => [
            'sectionTitleStrKey' => 'newsletter.contracts_title',
            'sectionType' => 'news',
            'types' => ['contracts'],
            'showDate' => false,
            'showCategoryTitle' => true,
            'defaultCategoryColor' => '#EA9675',
            'categoryFieldName' => 'business_areas',
            'defaultImageUrl' => 'vendor/maecia/isod-back/resources/assets/img/newsletter/default.jpg',
        ],
        'launches'       => [
            'sectionTitleStrKey' => 'newsletter.launches_title',
            'sectionType' => 'news',
            'types' => ['launches'],
            'showDate' => false,
            'showCategoryTitle' => true,
            'defaultCategoryColor' => '#EA9675',
            'categoryFieldName' => 'business_areas',
            'defaultImageUrl' => 'vendor/maecia/isod-back/resources/assets/img/newsletter/default.jpg',
        ],
        'events'     => [
            'sectionTitleStrKey' => 'newsletter.events_title',
            'types' => ['events'],
            'sorts' => ['date:desc'],
            'dateFormat' => '%A %d %B %Y',
            'categoryFieldName' => 'events_categories',
            'defaultCategoryColor' => '#1D91D3',
            'link' => [
                'sectionLinkUrl'   => 'evenements',
                'sectionTextColor' => '#8183c2',
            ],
        ],
        'documents'  => [
            'sectionTitleStrKey' => 'newsletter.documents_title',
            'types'           => ['documents'],
            'sorts' => ['published_at:desc'],
            'imageStyle' => 'medium',
            'dateFormat' => '%d %B %Y',
            'titleColor' => '#003A7B',
            'leftLineColor' => '#003A7B',
            'link'            => [
                'sectionLinkStrKey' => 'newsletter.see_all_documents',
                'sectionLinkUrl' => 'mediatheque',
                'sectionTextColor' => '#8183c2',
            ],
        ],
        'activities' => [
            'link'        => null, // Pas de links
            'orientation' => 'horizontal',
            'defaultBackgroundColor' => '#FFFFF',
            'defaultValueColor' => '#2c3f50',
            'items'       => [
                'comments' => [
                    'callback'           => function () {
                        return \Inside\Content\Models\Contents\Comments::count();
                    },
                    'backgroundImageUrl' => 'vendor/maecia/isod-back/resources/assets/img/newsletter/comments.png',
                    'titleStrKey'        => 'newsletter.comments_statistic',
                ],
                'likes'    => [
                    'callback'           => function () {
                        return \Inside\Reaction\Models\Reaction::where('type',
                            'like')->count();
                    },
                    'backgroundImageUrl' => 'vendor/maecia/isod-back/resources/assets/img/newsletter/likes.png',
                    'titleStrKey'        => 'newsletter.likes_statistic',
                ],
                'users'    => [
                    'callback'           => function () {
                        return \Inside\Content\Models\Contents\Users::where('status',
                            true)->count();
                    },
                    'backgroundImageUrl' => 'vendor/maecia/isod-back/resources/assets/img/newsletter/users.png',
                    'titleStrKey'        => 'newsletter.users_statistic',
                ],
                'news'     => [
                    'callback'           => function () {
                        return \Inside\Content\Models\Contents\News::where('status',
                            true)->count();
                    },
                    'backgroundImageUrl' => 'vendor/maecia/isod-back/resources/assets/img/newsletter/news.png',
                    'titleStrKey'        => 'newsletter.contents_statistic',
                ],
            ],
        ]
    ],
    'footer'       => [
        'backgroundColor' => '#F0F0F0',
        'unsubscribeTextColor' => '#818181',
        'unsubscribeTextStrKey' => 'newsletter.unsubscribe.warning'
    ],
];
