<?php

declare(strict_types=1);

use Illuminate\Database\Migrations\Migration;
use Inside\Content\Models\Contents\CompanyStatistics;
use Inside\Host\Bridge\BridgeContent;
use Inside\Host\Migrations\CreateContentTypes;

final class UpdateEcoDashboardsAndCompanyStatistics extends Migration
{
    use CreateContentTypes;

    public function up(): void
    {
        $this->bootUp(__FILE__);
        $this->migrateContent('eco_dashboards');
        $this->migrateContent('company_statistics');

        $bridgeContent = new BridgeContent();
        CompanyStatistics::each(fn (CompanyStatistics $statistics) => $bridgeContent->contentUpdate($statistics->content_type, ['uuid' => $statistics->uuid, 'show_progressbar' => true]));
        $this->finishUp();
    }
}
