<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Support\Facades\Artisan;
use Inside\Host\Bridge\BridgeContentType;

class UpdateSearchableFields extends Migration
{
    public function up(): void
    {
        $bridge = new BridgeContentType();

        $fields = ['phone', 'mobile_phone', 'office', 'other_location'];

        foreach ($fields as $field) {
            $original = \Inside\Content\Facades\Schema::getFieldOptions('users', $field);

            $options = [
                'title' => $original['title'],
                'search_result_field' => $original['search_result_field'],
                'searchable' => true,
            ];

            if (in_array($field, ['phone', 'mobile_phone'])) {
                $options = array_merge($options, [
                    'widget' => [
                        'type' => BridgeContentType::INSIDE_PHONE_WIDGET,
                    ],
                ]);
            }

            $bridge->contentTypeUpdateField('users', $field, $options);
        }

        Artisan::call('models:rebuild');
        Artisan::call('index:rebuild', ['--type' => 'users']);
    }

    public function down(): void
    {
    }
}
