<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class ReworkEquipmentImport extends Migration
{
    public function up(): void
    {
        if (Schema::hasTable('inside_sodern_softwares')) {
            Schema::drop('inside_sodern_softwares');
        }

        if (Schema::hasTable('inside_sodern_equipments')) {
            Schema::drop('inside_sodern_equipments');
        }

        Schema::create('inside_sodern_equipments', function (Blueprint $table) {
            $table->string('id', 25)->primary()->collate('utf8')->unique();
            $table->string('title', 255)->collate('utf8');
            $table->string('user_uuid', 36)->collate('utf8')->comment('Correspond to user uuid');
        });

        Schema::table('inside_sodern_equipments', function (Blueprint $table) {
            $table->foreign('user_uuid', 'iseq_user_uuid_foreign')
                ->references('uuid')->on('inside_content_users')
                ->onDelete('cascade');
        });

        Schema::create('inside_sodern_softwares', function (Blueprint $table) {
            $table->string('id', 25)->primary()->collate('utf8')->unique();
            $table->string('title', 255)->collate('utf8');
            $table->string('equipment_id', 12)->collate('utf8');
        });

        Schema::table('inside_sodern_softwares', function (Blueprint $table) {
            $table->foreign('equipment_id', 'isso_equipment_id_foreign')
                ->references('id')->on('inside_sodern_equipments')
                ->onDelete('cascade');
        });

        $bridge = new \Inside\Host\Bridge\BridgeContentType();

        $bridge->contentTypeDeleteField('user', 'user', 'equipments');
        $bridge->contentTypeDelete('equipment');
        $bridge->contentTypeDelete('software');
    }
}
