<?php

use Inside\Content\Models\Contents\Statistics;
use Inside\Content\Models\Contents\CompanyStatistics;
use Illuminate\Database\Migrations\Migration;
use Inside\Content\Facades\DynamicClass;
use Inside\Content\Facades\Schema;
use Inside\Database\Migrations\HasConsole;
use Inside\Host\Bridge\BridgeContent;
use Inside\Host\Bridge\BridgeContentType;
use Inside\Host\Migrations\CreateContentTypes;
use Inside\Content\Models\Contents\EcoDashboards;

class AddLabelToStatLinks extends Migration
{
    use CreateContentTypes;
    use HasConsole;

    /** @var array */
    protected $statisticContentType = [
        'options' => [
            'translatable' => false,
            'searchable' => false,
            'global_searchable' => false,
            'aliasable' => false,
            'permissible' => false,
            'categorizable' => false,
            'name' => 'company_statistics',
            'title' => [
                'fr' => 'Statistiques',
            ],
        ],
        'fields' => [
            // Color
            [
                'name' => 'color',
                'searchable' => false,
                'translatable' => true,
                'default' => '#4186A2',
                'search_result_field' => false,
                'required' => true,
                'weight' => 1,
                'title' => [
                    'fr' => 'Couleur',
                ],
                'description' => [
                    'fr' => '',
                ],
                'widget' => [
                    'type' => BridgeContentType::STRING_WIDGET,
                    'settings' => [
                        'size' => 60,
                        'placeholder' => '',
                    ],
                    'weight' => 1,
                ],
                'type' => BridgeContentType::TEXT_FIELD,
                'settings' => [
                    'max_length' => 255,
                    'is_ascii' => false,
                    'case_sensitive' => false,
                    'cardinality' => 1,
                ],
            ],
            // Actual value
            [
                'name' => 'current_value',
                'searchable' => false,
                'translatable' => false,
                'default' => 0,
                'search_result_field' => false,
                'required' => true,
                'weight' => 2,
                'title' => [
                    'fr' => 'Valeur actuelle',
                ],
                'description' => [
                    'fr' => '',
                ],
                'widget' => [
                    'type' => BridgeContentType::NUMBER_WIDGET,
                    'settings' => [
                        'placeholder' => '',
                    ],
                    'weight' => 2,
                ],
                'type' => BridgeContentType::INTEGER_FIELD,
                'settings' => [
                    'unsigned' => false,
                    'size' => 'normal',
                    'cardinality' => 1,
                ],
            ],
            // Annual objective
            [
                'name' => 'annual_objective',
                'searchable' => false,
                'translatable' => false,
                'default' => 0,
                'search_result_field' => false,
                'required' => true,
                'weight' => 4,
                'title' => [
                    'fr' => 'Objectif annuel',
                ],
                'description' => [
                    'fr' => '',
                ],
                'widget' => [
                    'type' => BridgeContentType::NUMBER_WIDGET,
                    'settings' => [
                        'placeholder' => '',
                    ],
                    'weight' => 4,
                ],
                'type' => BridgeContentType::INTEGER_FIELD,
                'settings' => [
                    'unsigned' => false,
                    'size' => 'normal',
                    'cardinality' => 1,
                ],
            ],
            // Midyear objective
            [
                'name' => 'midyear_objective',
                'searchable' => false,
                'translatable' => false,
                'default' => 0,
                'search_result_field' => false,
                'required' => false,
                'weight' => 3,
                'title' => [
                    'fr' => 'Objectif mi-annuel',
                ],
                'description' => [
                    'fr' => '',
                ],
                'widget' => [
                    'type' => BridgeContentType::NUMBER_WIDGET,
                    'settings' => [
                        'placeholder' => '',
                    ],
                    'weight' => 3,
                ],
                'type' => BridgeContentType::INTEGER_FIELD,
                'settings' => [
                    'unsigned' => false,
                    'size' => 'normal',
                    'cardinality' => 1,
                ],
            ],
            // Is highlighted
            [
                'type' => BridgeContentType::BOOLEAN_FIELD,
                'name' => 'is_highlighted',
                'searchable' => false,
                'translatable' => false,
                'default' => false,
                'search_result_field' => false,
                'required' => false,
                'title' => [
                    'fr' => 'Mis en avant?',
                ],
                'settings' => [
                    'cardinality' => 1,
                ],
                'widget' => [
                    'type' => BridgeContentType::BOOLEAN_CHECKBOX_WIDGET,
                    'settings' => [
                    ],
                    'group' => 'group_options',
                    'weight' => 1,
                ],
            ],
            // Weight
            [
                'name' => 'weight',
                'searchable' => false,
                'translatable' => true,
                'default' => 0,
                'search_result_field' => false,
                'required' => true,
                'weight' => 7,
                'title' => [
                    'fr' => 'Poids',
                ],
                'description' => [
                    'fr' => '',
                ],
                'widget' => [
                    'type' => BridgeContentType::NUMBER_WIDGET,
                    'settings' => [
                        'placeholder' => '',
                    ],
                    'group' => 'group_advanced_options',
                    'weight' => 202,
                ],
                'type' => BridgeContentType::INTEGER_FIELD,
                'settings' => [
                    'unsigned' => false,
                    'size' => 'normal',
                    'cardinality' => 1,
                ],
            ],
        ],
    ];

    public function up(): void
    {
        DynamicClass::disableRebuildAutoLoad();

        $this->bootUp(__FILE__, 'add_label_to_stat_links');

        // Création d'un contenu statistics
        $this->getBridge()->contentTypeCreate('company_statistics', $this->statisticContentType['options'], $this->statisticContentType['fields']);

        // add labels
        for ($i = 1; $i < 5; $i++) {
            $fieldOptions = $this->getLabelFieldOptions($i);
            $this->getBridge()->contentTypeCreateOrUpdateField('spaces', $fieldOptions['name'], $fieldOptions);
        }

        Schema::refresh();
        DynamicClass::enableRebuildAutoLoad();
        DynamicClass::rebuild();

        $bridge = new BridgeContent();

        // Copie des anciennes statistiques
        foreach (Statistics::all() as $statistic) {
            $this->write('Migration des statistics <fg=cyan>'.$statistic->title .'</>');
            $this->writeResult(null !==$bridge->contentInsert('company_statistics', [
                'status' => $statistic->status,
                'langcode' => $statistic->langcode,
                'title' => $statistic->title,
                'author' => $statistic->author,
                'created_at' => $statistic->created_at,
                'updated_at' => $statistic->updated_at,
                'annual_objective' => $statistic->annual_objective,
                'midyear_objective' => $statistic->midyear_objective,
                'weight' => $statistic->weight,
                'current_value' => $statistic->current_value,
                'color' => $statistic->color,
                'is_highlighted' => $statistic->is_highlighted ?? false,
            ]));
        }

        // Suppression de l'ancien contenu qui ne peut plus fonctionner avec inside-stats
        $this->getBridge()->contentTypeDelete('statistics');
        $this->getBridge()->contentTypeDeleteField('node', 'eco_dashboards', 'statistics');

        // Mise à jour de eco_dashboards
        $this->getBridge()->contentTypeCreateField('eco_dashboards', 'company_statistics', [
            'name' => 'company_statistics',
            'searchable' => false,
            'translatable' => false,
            'default' => [],
            'search_result_field' => false,
            'required' => false,
            'weight' => 1,
            'title' => [
                'fr' => 'Statistiques',
            ],
            'description' => [
                'fr' => '',
            ],
            'widget' => [
                'type' => BridgeContentType::SELECT_WIDGET,
                'settings' => [],
                'weight' => 1,
            ],
            'type' => BridgeContentType::REFERENCE_FIELD,
            'settings' => [
                'target_type' => ['company_statistics'],
                'cardinality' => -1,
            ],
        ]);

        // We need to reload classes now to be sure all is good
        DynamicClass::rebuild(true);

        // On met à jour le dashboard
        $ecoDashboard = EcoDashboards::first();
        $bridge->contentUpdate('eco_dashboards', [
            'uuid' => $ecoDashboard->uuid,
            'company_statistics' => CompanyStatistics::pluck('uuid')->toArray(),
        ]);
    }

    protected function getLabelFieldOptions(int $number): array
    {
        return [
            'type' => BridgeContentType::TEXT_FIELD,
            'name' => 'space_link'.$number.'_label',
            'searchable' => false,
            'translatable' => false,
            'search_result_field' => false,
            'required' => false,
            'default' => '',
            'title' => [
                'fr' => 'Intitulé de lien '.$number,
            ],
            'settings' => [
                'cardinality' => 1,
                'max_length' => 255
            ],
            'widget' => [
                'type' => BridgeContentType::TEXT_WIDGET,
                'settings' => [
                    'size' => 250,
                    'placeholder' => '',
                ],
                'group' => 'space_header_links',
                'weight' => (100+$number),
            ],
        ];
    }
}
