<?php

use Illuminate\Database\Migrations\Migration;
use Inside\Content\Facades\DynamicClass;
use Inside\Database\Migrations\HasConsole;
use Inside\Host\Bridge\BridgeContentType;
use Inside\Content\Facades\Schema;
use Inside\Host\Migrations\CreateContentTypes;

class AddIsHighlightedFieldToStats extends Migration
{
    use CreateContentTypes;
    use HasConsole;

    public function up(): void
    {
        DynamicClass::disableRebuildAutoLoad();

        $this->bootUp(__FILE__, 'add_is_highlighted_field_to_tasts');

        $this->getBridge()->contentTypeCreateOrUpdateField(
            'statistics',
            'is_highlighted',
            [
                'type' => BridgeContentType::BOOLEAN_FIELD,
                'name' => 'is_highlighted',
                'searchable' => false,
                'translatable' => false,
                'default' => false,
                'search_result_field' => false,
                'required' => false,
                'title' => [
                    'fr' => 'Mis en avant?',
                ],
                'settings' => [
                    'cardinality' => 1,
                ],
                'widget' => [
                    'type' => BridgeContentType::BOOLEAN_CHECKBOX_WIDGET,
                    'settings' => [
                    ],
                    'group' => 'group_options',
                    'weight' => 4,
                ],
            ]
        );

        Schema::refresh();
        DynamicClass::enableRebuildAutoLoad();
        $this->call('models:rebuild');
    }
}
