<?php

use Illuminate\Database\Migrations\Migration;
use Inside\Content\Facades\DynamicClass;
use Inside\Database\Migrations\HasConsole;
use Inside\Dms\Facades\Dms;
use Inside\Host\Bridge\BridgeContentType;
use Inside\Host\Migrations\CreateContentTypes;

class AddNewUserFields7942 extends Migration
{
    use CreateContentTypes;
    use HasConsole;

    /** @var array */
    protected $fields = [
        [
            'name' => 'associative_role',
            'searchable' => false,
            'translatable' => false,
            'search_result_field' => true,
            'required' => false,
            'editable' => true,
            'title' => [
                'fr' => 'Rôle associatif',
            ],
            'widget' => [
                'type' => BridgeContentType::STRING_WIDGET,
                'settings' => [
                    'size' => 60,
                    'placeholder' => '',
                ],
                'group' => 'associative_roles',
                'weight' => 81,
            ],
            'type' => BridgeContentType::TEXT_FIELD,
            'settings' => [
                'max_length' => 255,
                'is_ascii' => false,
                'case_sensitive' => false,
                'cardinality' => 1,
            ],
        ],
        [
            'name' => 'programs',
            'searchable' => true,
            'translatable' => false,
            'search_result_field' => true,
            'required' => false,
            'editable' => true,
            'classifiable' => 'programs_categories',
            'title' => [
                'fr' => 'Programmes',
            ],
            'widget' => [
                'type' => BridgeContentType::SELECT_WIDGET,
                'settings' => [],
                'group' => 'programs',
                'weight' => 91,
            ],
            'type' => BridgeContentType::REFERENCE_FIELD,
            'settings' => [
                'target_type' => ['programs'],
                'cardinality' => -1,
            ],
            'selectable_all' => false,
        ],
        [
            'name' => 'who_to_contact',
            'searchable' => false,
            'translatable' => false,
            'search_result_field' => true,
            'required' => false,
            'editable' => true,
            'weight' => 1,
            'title' => [
                'fr' => 'Rechercher une personne',
            ],
            'widget' => [
                'type' => BridgeContentType::AUTOCOMPLETE_WIDGET,
                'settings' => [],
                'group' => 'who_to_contact',
                'weight' => 111,
            ],
            'type' => BridgeContentType::REFERENCE_FIELD,
            'settings' => [
                'target_type' => 'users',
                'cardinality' => 1,
            ],
        ],
        [
            'name' => 'cost_center',
            'searchable' => false,
            'translatable' => false,
            'search_result_field' => true,
            'required' => false,
            'weight' => 0,
            'title' => [
                'fr' => 'Centre de coût',
            ],
            'widget' => [
                'hidden' => true,
            ],
            'type' => BridgeContentType::TEXT_FIELD,
            'settings' => [
                'max_length' => 255,
                'is_ascii' => false,
                'case_sensitive' => false,
                'cardinality' => 1,
            ],
        ],
        [
            'name' => 'linkedin',
            'searchable' => false,
            'translatable' => false,
            'search_result_field' => true,
            'required' => false,
            'editable' => true,
            'weight' => 2,
            'title' => [
                'fr' => 'LinkedIn',
            ],
            'widget' => [
                'hidden' => true,
            ],
            'type' => BridgeContentType::TEXT_FIELD,
            'settings' => [
                'max_length' => 255,
                'is_ascii' => false,
                'case_sensitive' => false,
                'cardinality' => 1,
            ],
        ],
    ];

    /** @var array */
    protected $groups = [
        [
            'name' => 'associative_roles',
            'title' => 'Rôle associatif',
            'weight' => 80
        ],
        [
            'name' => 'programs',
            'title' => 'Programme',
            'weight' => 90,
        ],
        [
            'name' => 'who_to_contact',
            'title' => 'Qui contacter en mon absence ?',
            'weight' => 110,
        ]
    ];

    public function up(): void
    {
        DynamicClass::disableRebuildAutoLoad();

        $this->bootUp(__FILE__, 'add_news_user_fields');

        $this->migrateContent('programs_categories');
        $this->migrateContent('programs');


        foreach ($this->groups as $group) {
            $this->write('Ajout du fieldset <fg=cyan>' . $group['title'] . '</>');
            $this->writeResult(
                $this->getBridge()->createOrUpdateFieldGroup(
                    'users',
                    $group['name'],
                    [
                        'fr' => $group['title'],
                    ],
                    $group['weight']
                )
            );
        }

        foreach ($this->fields as $field) {
            $this->bridge->contentTypeCreateOrUpdateField('users', $field['name'], $field);
        }

        $this->finishUp();

        DynamicClass::enableRebuildAutoLoad();
        $this->call('models:rebuild');
    }
}
