<?php

use Illuminate\Database\Migrations\Migration;
use Inside\Host\Migrations\CreateContentTypes;
use Illuminate\Support\Facades\Artisan;

/**
 * Class AddNewSearchableInDirectory
 *
 */
class MakeUserFieldsSearchable extends Migration
{
    use CreateContentTypes;

    public function up(): void
    {
        $this->bootUp(__FILE__);
        foreach (
            [
                'samaccountname',
                'trigram',
            ] as $fieldName
        ) {
            $this->getBridge()->updateFieldOptions(
                'users',
                $fieldName,
                [
                    'searchable' => 1,
                ]
            );
        }
        Artisan::call('index:rebuild', ['--type' => 'users']);

        $this->finishUp();
    }
}
