<?php

use Illuminate\Database\Migrations\Migration;
use Inside\Host\Bridge\BridgeContentType;

class MakeEventStartDateRequired extends Migration
{
    public function up(): void
    {
        $bridge = new BridgeContentType();
        $bridge->contentTypeCreateOrUpdateField(
            'events',
            'date',
            [
                'title' => [
                    'fr' => 'Date'
                ],
                'type'     => BridgeContentType::TIMESTAMP_FIELD,
                'required' => true,
            ]
        );
        $bridge->contentTypeDeleteField('node', 'events', 'end_dates');
    }
}
