<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class IdeaBox extends Migration
{
    use \Inside\Host\Migrations\CreateContentTypes;


    /** @var array */
    protected $layouts = [
        'Liste des idées'  => [
            'paths'  => [
                'fr' => 'les-idees',
            ],
            'config' => [
                'blocks' => '{"block-default-listing-layouts-24du9gex9-0":{"parentID":"layouts-24du9gex9","module":{"module":"InsideListing","display":"default"},"blockID":"block-default-listing-layouts-24du9gex9-0","blockName":"default-listing","blockData":{},"blockOptions":{"content":{"contentTypes":["ideas"],"blockFilters":[],"blockFiltersDefault":{"sort":"created_at","limit":"15","offset":"0","order":"desc","paginate":1,"tree_sort":null,"tree_order":null},"blockFields":[{"fieldType":"timestamp","key":"created_at","value":null}],"formattedContents":"ideas","formattedFields":["created_at"],"formattedFilters":{"sort":"created_at:desc","limit":"15","offset":"0","paginate":1},"normalizer":null,"customFilters":null},"general":{"blockImageDisplay":"content","blockTitle":null,"blockSubtitle":"","blockAlignment":"left","blockImage":null,"blockImageHeight":25,"blockClass":"","hasBlockImage":false,"hasNoData":null,"relativeBlock":"parent","parentBlock":null,"childFilters":[],"hasGeneralLink":false,"isExternalLink":false,"urlGeneralLink":null,"urlGeneralLinkHide":null,"urlGeneralLabel":null,"printable":true,"useDefaultHeaderLayout":true,"useDefaultLinkLayout":true,"hideBlock":null,"blockId":"block-default-listing-layouts-24du9gex9-0"},"display":{},"filters":{"interfaceFilters":"[{\"type\":\"search\",\"model\":\"ideas\",\"label\":\"Rechercher une idée\"}]","hideMyEvents":true},"list":{"modalName":"ideas","columnsList":"title,authors,services,created_at,status","noResultLabelList":{"fr":"Aucune idée n\'a été proposée"},"isExportable":"","exportUrl":"","hideEdition":false,"allowGlobalExport":false,"exportExtension":"csv","exportFilename":"export","exportIcon":"export","defaultListView":"list"},"custom":{"hasBookmarkComponent":false,"goToOnClick":null,"classname":"","canToggleDisplay":false,"isComponentListing":true,"cardUsersComponent":null,"componentName":"list-item-ideas-customs"},"counters":{}},"blockPos":0,"isMainBlock":true},"block-sub-header-ui-layouts-rok31c3rs-0":{"parentID":"layouts-rok31c3rs","module":{"module":"InsideUi","display":"sub-header"},"blockID":"block-sub-header-ui-layouts-rok31c3rs-0","blockName":"sub-header-ui","blockData":{},"blockOptions":{"content":{"contentTypes":["custom"],"blockFilters":[{"key":"slug","value":"les-idees","index":0,"type":"filter","fieldType":"text","target":null,"operation":"eq"}],"blockFiltersDefault":{"sort":null,"limit":null,"offset":null,"order":"asc","paginate":0,"tree_sort":null,"tree_order":null},"blockFields":[{"fieldType":"onoff","key":"count","value":null},{"fieldType":"onoff","key":"total_count","value":null},{"fieldType":"onoff","key":"tree","value":null},{"fieldType":"onoff","key":"parent_tree","value":null},{"fieldType":"checkbox","key":"status","value":null},{"fieldType":"string","key":"pid","value":null},{"fieldType":"wysiwyg","key":"body","value":null},{"fieldType":"select","key":"langcode","value":null},{"fieldType":"link","key":"link","value":null},{"fieldType":"onoff","key":"admin","value":null},{"fieldType":"text","key":"title","value":null},{"fieldType":"text","key":"link_title","value":null},{"fieldType":"string","key":"content_type","value":null},{"fieldType":"string","key":"slug","value":null},{"fieldType":"string","key":"uuid","value":null}],"formattedContents":"custom","formattedFields":["count","total_count","tree","parent_tree","status","pid","body","langcode","link","admin","title","link_title","content_type","slug","uuid"],"formattedFilters":{"slug:eq":"les-idees"},"normalizer":null,"customFilters":null},"general":{"blockImageDisplay":"content","blockTitle":{"fr":"${`title`}"},"blockSubtitle":{"fr":"${`body`}"},"blockAlignment":"left","blockImage":null,"blockImageHeight":25,"blockClass":"","hasBlockImage":false,"hasNoData":null,"relativeBlock":"parent","parentBlock":null,"childFilters":[],"hasGeneralLink":false,"isExternalLink":false,"urlGeneralLink":null,"urlGeneralLinkHide":null,"urlGeneralLabel":null,"printable":true,"useDefaultHeaderLayout":true,"useDefaultLinkLayout":true,"hideBlock":null,"blockId":"block-sub-header-ui-layouts-rok31c3rs-0"},"display":{},"filters":{},"list":{},"custom":{"cover":"${`image`}","componentHeader":"header-button-customs"},"counters":{"count":1,"totalCount":1}},"blockPos":0,"isMainBlock":true}}',
                'layout' => '{"rows-0":{"id":"rows-0","forms":{},"layouts":{"layouts-rok31c3rs":{"rows":{"rows-rok31c3rs-0":{"id":"rows-rok31c3rs-0","layouts":{},"layoutCounter":0}},"id":"layouts-rok31c3rs","columns":1,"blocks":["block-sub-header-ui-layouts-rok31c3rs-0"],"options":{"width":{},"maxWidth":{},"alignment":"left","colCount":1,"colOptions":{"0":{"width":{"value":null,"unit":null},"margins":{"top":0,"right":0,"bottom":0,"left":0}}},"bgColor":"none","settingsProperty":"","noBlock":false,"layoutClass":"ideas-header","template":"none"},"parentID":"rows-0"},"layouts-24du9gex9":{"rows":{"rows-24du9gex9-0":{"id":"rows-24du9gex9-0","layouts":{},"layoutCounter":0}},"id":"layouts-24du9gex9","columns":1,"blocks":["block-default-listing-layouts-24du9gex9-0"],"options":{"width":{"value":"100","unit":"%"},"maxWidth":{"value":"1200","unit":"px"},"alignment":"left","colCount":1,"colOptions":{"0":{"default":{"width":{"value":null,"unit":null},"maxWidth":{"value":null,"unit":null},"margins":{"top":"50","right":0,"bottom":"50","left":0},"useCurrentBreakpoint":null},"small-desktop":{"width":{"value":null,"unit":null},"maxWidth":{"value":null,"unit":null},"margins":{"top":0,"right":0,"bottom":0,"left":0},"useCurrentBreakpoint":null},"tablet":{"width":{"value":null,"unit":null},"maxWidth":{"value":null,"unit":null},"margins":{"top":0,"right":0,"bottom":0,"left":0},"useCurrentBreakpoint":null},"mobile":{"width":{"value":null,"unit":null},"maxWidth":{"value":null,"unit":null},"margins":{"top":0,"right":0,"bottom":0,"left":0},"useCurrentBreakpoint":null}}},"bgColor":"none","settingsProperty":"","noBlock":false,"layoutClass":"","template":"none"},"parentID":"rows-0"}},"layoutCounter":2}}',
                'option' => '{"allowedContents":["ideas"]}',
            ],
        ],
        'Liste de mes idées'  => [
            'paths'  => [
                'fr' => 'mes-idees',
            ],
            'config' => [
                'blocks' => '{"block-default-listing-layouts-24du9gex9-0":{"parentID":"layouts-24du9gex9","module":{"module":"InsideListing","display":"default"},"blockID":"block-default-listing-layouts-24du9gex9-0","blockName":"default-listing","blockData":{},"blockOptions":{"content":{"contentTypes":["ideas"],"blockFilters":[{"key":"authors","value":[{"key":"uuid","value":"25e3145a-657d-4e80-9994-46102e7f1f80","operation":"eq","fieldType":"text","isReversed":false,"target":null,"index":0,"type":"filter"}],"index":0,"type":"filter","fieldType":"reference","target":["users"],"operation":"eq"}],"blockFiltersDefault":{"sort":"created_at","limit":"15","offset":"0","order":"desc","paginate":1,"tree_sort":null,"tree_order":null},"blockFields":[{"fieldType":"timestamp","key":"created_at","value":null}],"formattedContents":"ideas","formattedFields":["created_at"],"formattedFilters":{"authors":{"uuid:eq":"25e3145a-657d-4e80-9994-46102e7f1f80"},"sort":"created_at:desc","limit":"15","offset":"0","paginate":1},"normalizer":null,"customFilters":null},"general":{"blockImageDisplay":"content","blockTitle":null,"blockSubtitle":"","blockAlignment":"left","blockImage":null,"blockImageHeight":25,"blockClass":"","hasBlockImage":false,"hasNoData":null,"relativeBlock":"parent","parentBlock":null,"childFilters":[],"hasGeneralLink":true,"isExternalLink":false,"urlGeneralLink":{"fr":"les-idees"},"urlGeneralLinkHide":null,"urlGeneralLabel":{"fr":"Voir toutes les idées"},"printable":true,"useDefaultHeaderLayout":true,"useDefaultLinkLayout":true,"hideBlock":null,"blockId":"block-default-listing-layouts-24du9gex9-0"},"display":{},"filters":{"interfaceFilters":"[{\"type\":\"search\",\"model\":\"ideas\",\"label\":\"Rechercher une idée\"}]","hideMyEvents":true},"list":{"modalName":"ideas","columnsList":"title,authors,services,created_at,status","noResultLabelList":{"fr":"Vous n\'avez pas encore proposé d\'idée"},"isExportable":"","exportUrl":"","hideEdition":false,"allowGlobalExport":false,"exportExtension":"csv","exportFilename":"export","exportIcon":"export","defaultListView":"list"},"custom":{"hasBookmarkComponent":false,"goToOnClick":null,"classname":"","canToggleDisplay":false,"isComponentListing":true,"cardUsersComponent":null,"componentName":"list-item-ideas-customs"},"counters":{}},"blockPos":0,"isMainBlock":true},"block-sub-header-ui-layouts-rok31c3rs-0":{"parentID":"layouts-rok31c3rs","module":{"module":"InsideUi","display":"sub-header"},"blockID":"block-sub-header-ui-layouts-rok31c3rs-0","blockName":"sub-header-ui","blockData":{},"blockOptions":{"content":{"contentTypes":["custom"],"blockFilters":[{"key":"slug","value":"les-idees","index":0,"type":"filter","fieldType":"text","target":null,"operation":"eq"}],"blockFiltersDefault":{"sort":null,"limit":null,"offset":null,"order":"asc","paginate":0,"tree_sort":null,"tree_order":null},"blockFields":[{"fieldType":"wysiwyg","key":"body","value":null},{"fieldType":"link","key":"link","value":null},{"fieldType":"onoff","key":"admin","value":null},{"fieldType":"text","key":"title","value":null},{"fieldType":"text","key":"link_title","value":null},{"fieldType":"string","key":"content_type","value":null},{"fieldType":"string","key":"slug","value":null},{"fieldType":"string","key":"uuid","value":null}],"formattedContents":"custom","formattedFields":["body","link","admin","title","link_title","content_type","slug","uuid"],"formattedFilters":{"slug:eq":"les-idees"},"normalizer":null,"customFilters":null},"general":{"blockImageDisplay":"content","blockTitle":{"fr":"${`title`}"},"blockSubtitle":{"fr":"${`body`}"},"blockAlignment":"left","blockImage":null,"blockImageHeight":25,"blockClass":"","hasBlockImage":false,"hasNoData":null,"relativeBlock":"parent","parentBlock":null,"childFilters":[],"hasGeneralLink":false,"isExternalLink":false,"urlGeneralLink":null,"urlGeneralLinkHide":null,"urlGeneralLabel":null,"printable":true,"useDefaultHeaderLayout":true,"useDefaultLinkLayout":true,"hideBlock":null,"blockId":"block-sub-header-ui-layouts-rok31c3rs-0"},"display":{},"filters":{},"list":{},"custom":{"cover":"${`image`}","componentHeader":"header-button-customs"},"counters":{}},"blockPos":0,"isMainBlock":true}}',
                'layout' => '{"rows-0":{"id":"rows-0","forms":{},"layouts":{"layouts-rok31c3rs":{"rows":{"rows-rok31c3rs-0":{"id":"rows-rok31c3rs-0","layouts":{},"layoutCounter":0}},"id":"layouts-rok31c3rs","columns":1,"blocks":["block-sub-header-ui-layouts-rok31c3rs-0"],"options":{"width":{},"maxWidth":{},"alignment":"left","colCount":1,"colOptions":{"0":{"width":{"value":null,"unit":null},"margins":{"top":0,"right":0,"bottom":0,"left":0}}},"bgColor":"none","settingsProperty":"","noBlock":false,"layoutClass":"ideas-header","template":"none"},"parentID":"rows-0"},"layouts-24du9gex9":{"rows":{"rows-24du9gex9-0":{"id":"rows-24du9gex9-0","layouts":{},"layoutCounter":0}},"id":"layouts-24du9gex9","columns":1,"blocks":["block-default-listing-layouts-24du9gex9-0"],"options":{"width":{"value":"100","unit":"%"},"maxWidth":{"value":"1200","unit":"px"},"alignment":"left","colCount":1,"colOptions":{"0":{"default":{"width":{"value":null,"unit":null},"maxWidth":{"value":null,"unit":null},"margins":{"top":"50","right":0,"bottom":"50","left":0},"useCurrentBreakpoint":null},"small-desktop":{"width":{"value":null,"unit":null},"maxWidth":{"value":null,"unit":null},"margins":{"top":0,"right":0,"bottom":0,"left":0},"useCurrentBreakpoint":null},"tablet":{"width":{"value":null,"unit":null},"maxWidth":{"value":null,"unit":null},"margins":{"top":0,"right":0,"bottom":0,"left":0},"useCurrentBreakpoint":null},"mobile":{"width":{"value":null,"unit":null},"maxWidth":{"value":null,"unit":null},"margins":{"top":0,"right":0,"bottom":0,"left":0},"useCurrentBreakpoint":null}}},"bgColor":"none","settingsProperty":"","noBlock":false,"layoutClass":"","template":"none"},"parentID":"rows-0"}},"layoutCounter":2}}',
                'option' => '{"allowedContents":["ideas"]}',
            ],
        ],
        'Proposer une idée'  => [
            'paths'  => [
                'fr' => 'proposer-une-nouvelle-idee',
            ],
            'config' => [
                'blocks' => '{"block-form-ideas-customs-layouts-vjmhzlvn1-0":{"parentID":"layouts-vjmhzlvn1","module":{"module":"InsideCustoms","display":"form-ideas"},"blockID":"block-form-ideas-customs-layouts-vjmhzlvn1-0","blockName":"form-ideas-customs","blockData":{},"blockOptions":{"content":{"contentTypes":["custom"],"blockFilters":[{"key":"slug","value":"proposer-une-nouvelle-idee","index":0,"type":"filter","fieldType":"text","target":null,"operation":"eq"}],"blockFiltersDefault":{"sort":null,"limit":null,"offset":null,"order":"asc","paginate":0,"tree_sort":null,"tree_order":null},"blockFields":[{"fieldType":"wysiwyg","key":"body","value":null},{"fieldType":"link","key":"link","value":null},{"fieldType":"onoff","key":"admin","value":null},{"fieldType":"text","key":"title","value":null},{"fieldType":"text","key":"link_title","value":null},{"fieldType":"string","key":"content_type","value":null},{"fieldType":"string","key":"slug","value":null},{"fieldType":"string","key":"uuid","value":null}],"formattedContents":"custom","formattedFields":["body","link","admin","title","link_title","content_type","slug","uuid"],"formattedFilters":{"slug:eq":"proposer-une-nouvelle-idee"},"normalizer":null,"customFilters":null},"general":{"blockImageDisplay":"content","blockTitle":{"fr":""},"blockSubtitle":{"fr":""},"blockAlignment":"center","blockImage":null,"blockImageHeight":25,"blockClass":"","hasBlockImage":false,"hasNoData":null,"relativeBlock":"parent","parentBlock":null,"childFilters":[],"hasGeneralLink":false,"isExternalLink":false,"urlGeneralLink":{"fr":"mes-idees"},"urlGeneralLinkHide":null,"urlGeneralLabel":{"fr":"Voir mes idées"},"printable":true,"useDefaultHeaderLayout":true,"useDefaultLinkLayout":true,"hideBlock":null,"blockId":"block-form-ideas-customs-layouts-vjmhzlvn1-0"},"display":{},"filters":{},"list":{},"custom":{},"counters":{}},"blockPos":0,"isMainBlock":true},"block-back-to-parent-utils-layouts-jbk5m9r6c-0":{"parentID":"layouts-jbk5m9r6c","module":{"module":"InsideUtils","display":"back-to-parent"},"blockID":"block-back-to-parent-utils-layouts-jbk5m9r6c-0","blockName":"back-to-parent-utils","blockData":{},"blockOptions":{"content":{},"general":{"blockImageDisplay":"content","blockTitle":null,"blockSubtitle":"","blockAlignment":"left","blockImage":null,"blockImageHeight":25,"blockClass":"","hasBlockImage":false,"hasNoData":true,"relativeBlock":null,"parentBlock":null,"childFilters":[],"hasGeneralLink":true,"isExternalLink":false,"urlGeneralLink":{"fr":"les-idees"},"urlGeneralLinkHide":null,"urlGeneralLabel":{"fr":"Retour aux idées"},"printable":true,"useDefaultHeaderLayout":true,"useDefaultLinkLayout":false,"hideBlock":null,"blockId":"block-back-to-parent-utils-layouts-jbk5m9r6c-0"},"display":{},"filters":{},"list":{},"custom":{}},"blockPos":0,"isMainBlock":false}}',
                'layout' => '{"rows-0":{"id":"rows-0","forms":{},"layouts":{"layouts-jbk5m9r6c":{"rows":{"rows-jbk5m9r6c-0":{"id":"rows-jbk5m9r6c-0","layouts":{},"layoutCounter":0}},"id":"layouts-jbk5m9r6c","columns":1,"blocks":["block-back-to-parent-utils-layouts-jbk5m9r6c-0"],"options":{"width":{},"maxWidth":{},"alignment":"left","colCount":1,"colOptions":{"0":{"width":{"value":null,"unit":null},"margins":{"top":0,"right":0,"bottom":0,"left":0}}},"bgColor":"none","settingsProperty":"","noBlock":false,"layoutClass":"back-to-my-ideas","template":"none"},"parentID":"rows-0"},"layouts-vjmhzlvn1":{"rows":{"rows-vjmhzlvn1-0":{"id":"rows-vjmhzlvn1-0","layouts":{},"layoutCounter":0}},"id":"layouts-vjmhzlvn1","columns":1,"blocks":["block-form-ideas-customs-layouts-vjmhzlvn1-0"],"options":{"width":{"value":"100","unit":"%"},"maxWidth":{"value":"100","unit":"%"},"alignment":"left","colCount":1,"colOptions":{"0":{"default":{"width":{"value":null,"unit":null},"maxWidth":{"value":null,"unit":null},"margins":{"top":"-62","right":0,"bottom":0,"left":0},"useCurrentBreakpoint":null},"small-desktop":{"width":{"value":null,"unit":null},"maxWidth":{"value":null,"unit":null},"margins":{"top":0,"right":0,"bottom":0,"left":0},"useCurrentBreakpoint":null},"tablet":{"width":{"value":null,"unit":null},"maxWidth":{"value":null,"unit":null},"margins":{"top":0,"right":0,"bottom":0,"left":0},"useCurrentBreakpoint":null},"mobile":{"width":{"value":null,"unit":null},"maxWidth":{"value":null,"unit":null},"margins":{"top":0,"right":0,"bottom":0,"left":0},"useCurrentBreakpoint":null}}},"bgColor":"none","settingsProperty":"","noBlock":false,"layoutClass":"","template":"none"},"parentID":"rows-0"}},"layoutCounter":2}}',
                'option' => '{"allowedContents":[]}',
            ],
        ],
    ];


    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up(): void
    {
        $this->bootUp(__FILE__);

        $this->migrateContent('ideas', false);


        $this->finishUp();
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down(): void
    {
    }
}
