<?php

use Inside\Host\Bridge\BridgeContentType;

$weight = 0;
return [
    'options' => [
        'translatable'      => false,
        'searchable'        => true,
        'global_searchable' => false,
        'aliasable'         => false,
        'permissible'       => true,
        'categorizable'     => false,
        'listing_type'      => 'content',
        'name'              => 'ideas',
        'title'             => [
            'fr' => 'Idées',
        ],
    ],
    'fields'  => [
        // Titre de l'idée

        // Status de l'idée
        [
            'type'                => BridgeContentType::TEXT_FIELD,
            'name'                => 'idea_status',
            'searchable'          => false,
            'translatable'        => false,
            'search_result_field' => false,
            'required'            => false,
            'weight'              => $weight++,
            'title'               => [
                'fr' => 'Status de l\'idée',
            ],
            'description'         => [
                'fr' => '',
            ],
            'settings' => [
            ],
            'widget'              => [
                'type'     => BridgeContentType::TEXT_WIDGET,
                'hidden' => true,
                'settings' => [
                ],
            ],
        ],

        // Type d'idée
        [
            'type'                => BridgeContentType::LIST_STRING_FIELD,
            'name'                => 'idea_type',
            'searchable'          => false,
            'translatable'        => false,
            'search_result_field' => false,
            'required'            => true,
            'weight'              => $weight++,
            'title'               => [
                'fr' => 'Type',
            ],
            'description'         => [
                'fr' => '',
            ],
            'settings' => [
                'allowed_values' => [
                    'simple' => [
                        'fr' => 'Simple',
                    ],
                    'complexe' => [
                        'fr' => 'Complexe',
                    ],
                ],
            ],
            'widget'              => [
                'type'     => BridgeContentType::SELECT_WIDGET,
                'settings' => [
                ],
            ],
        ],

        // Description de l'idée
        [
            'type'                => BridgeContentType::LONGTEXT_FIELD,
            'name'                => 'idea_description',
            'searchable'          => false,
            'translatable'        => false,
            'search_result_field' => false,
            'required'            => true,
            'weight'              => $weight++,
            'title'               => [
                'fr' => 'Description',
            ],
            'description'         => [
                'fr' => '',
            ],
            'settings' => [
            ],
            'widget'              => [
                'type'     => BridgeContentType::LONGTEXT_WIDGET,
                'settings' => [
                ],
            ],
        ],

        // Valideur
        [
            'type'                => BridgeContentType::REFERENCE_FIELD,
            'name'                => 'idea_validator',
            'searchable'          => false,
            'translatable'        => false,
            'search_result_field' => true,
            'required'            => false,
            'weight'              => $weight++,
            'title'               => [
                'fr' => 'Valideur',
            ],
            'description'         => [
                'fr' => '',
            ],
            'settings' => [
                'cardinality' => 1,
                'target_type' => 'users',
            ],
            'widget'              => [
                'type'     => BridgeContentType::SELECT_WIDGET,
                'settings' => [],
            ],
        ],

        // Collaborateur
        [
            'type'                => BridgeContentType::REFERENCE_FIELD,
            'name'                => 'idea_collaborator',
            'searchable'          => false,
            'translatable'        => false,
            'search_result_field' => true,
            'required'            => false,
            'weight'              => $weight++,
            'title'               => [
                'fr' => 'Collaborateur',
            ],
            'description'         => [
                'fr' => '',
            ],
            'settings' => [
                'cardinality' => 1,
                'target_type' => 'users',
            ],
            'widget'              => [
                'type'     => BridgeContentType::SELECT_WIDGET,
                'settings' => [],
            ],
        ],

        // Fichier
        [
            'type'                => BridgeContentType::FILE_FIELD,
            'name'                => 'idea_file',
            'searchable'          => false,
            'translatable'        => false,
            'search_result_field' => false,
            'required'            => false,
            'weight'              => $weight++,
            'title'               => [
                'fr' => 'Fichier',
            ],
            'description'         => [
                'fr' => '',
            ],
            'settings' => [
                'cardinality' => 1,
            ],
            'widget'              => [
                'type'     => BridgeContentType::FILE_WIDGET,
                'settings' => [],
            ],
        ],

        // Demandeur notifié ?
        [
            'type'                => BridgeContentType::BOOLEAN_FIELD,
            'name'                => 'idea_applicant_notified',
            'searchable'          => false,
            'translatable'        => false,
            'search_result_field' => false,
            'required'            => false,
            'default'             => true,
            'weight'              => $weight++,
            'title'               => [
                'fr' => 'Demandeur notifié ?',
            ],
            'description'         => [
                'fr' => '',
            ],
            'settings' => [
            ],
            'widget'              => [
                'type'     => BridgeContentType::BOOLEAN_CHECKBOX_WIDGET,
                'settings' => [
                ],
            ],
        ],

        // Commentaire
        [
            'type'                => BridgeContentType::LONGTEXT_FIELD,
            'name'                => 'idea_comment',
            'searchable'          => false,
            'translatable'        => false,
            'search_result_field' => false,
            'required'            => false,
            'default'             => '',
            'weight'              => $weight++,
            'title'               => [
                'fr' => 'Commentaire',
            ],
            'description'         => [
                'fr' => '',
            ],
            'settings' => [
            ],
            'widget'              => [
                'type'     => BridgeContentType::LONGTEXT_WIDGET,
                'settings' => [
                ],
            ],
        ],
    ],
];
