<?php

use Illuminate\Support\Facades\Log;

return [
    'schedule' => [
        'log_status' => function ($scheduler) {
            $scheduler->call(
                function () {
                    Log::info('Scheduler is running.');
                }
            )->hourly();
        },
        'cleanup' => function ($scheduler) {
            $scheduler->command('inside:cleanup')->sendOutputTo(
                cms_base_path(
                    env('APP_LOG_PATH', storage_path()) . DIRECTORY_SEPARATOR . 'cleanup_' . date(
                        'Y_m_d_His'
                    ) . '.log'
                )
            )->daily()->at('0:20');
        },
        'import'     => function ($scheduler) {
            // Material Import
            $scheduler->command(
                'inside:isod:import equipment ' . env('ISOD_EQUIPMENT_FILE_PATH', cms_base_path('MonMateriel_exemple.csv'))
            )->sendOutputTo(
                cms_base_path(
                    env('APP_LOG_PATH', storage_path()) . DIRECTORY_SEPARATOR . 'import_equipment_' . date(
                        'Y_m_d_His'
                    ) . '.log'
                )
            )->daily()->at(env('ISOD_EQUIPMENT_IMPORT_TIME', '3:00'));

            // Software import
            $scheduler->command(
                'inside:isod:import software ' . env('ISOD_SOFTWARE_FILE_PATH', cms_base_path('MesApplications_exemple.csv'))
            )->sendOutputTo(
                cms_base_path(
                    env('APP_LOG_PATH', storage_path()) . DIRECTORY_SEPARATOR . 'import_software_' . date(
                        'Y_m_d_His'
                    ) . '.log'
                )
            )->daily()->at(env('ISOD_SOFTWARE_IMPORT_TIME', '5:00'));

            // AD Import
            if (app()->environment() == 'production') {
                $scheduler->command('inside:user:import ldap --disable-not-imported')->sendOutputTo(
                    cms_base_path(
                        env('APP_LOG_PATH', storage_path()) . DIRECTORY_SEPARATOR . 'import_users_' . date(
                            'Y_m_d_His'
                        ) . '.log'
                    )
                )->twiceDaily(env('ISOD_USER_IMPORT_TIME_FIRST', 2), env('ISOD_USER_IMPORT_TIME_SECOND', 13));
            }
        },
    ],
];
